// -*- c++ -*-
//  Generated by gtkmmproc from ./../tipsquery.gen_h -- DO NOT MODIFY!
#ifndef _GTKMM_TIPSQUERY_H
#define _GTKMM_TIPSQUERY_H

/* $Id: tipsquery.h,v 1.2 2003/06/17 16:37:41 pbd Exp $ */

/* tipsquery.h
 *
 * Copyright (C) 1998-1999 The Gtk-- Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gtk--/label.h>
#include <gtk/gtktipsquery.h>

namespace Gtk {
class TipsQuery;
class TipsQuery_Class;
}
namespace Gtk { Gtk::TipsQuery *wrap (GtkTipsQuery *o); }
namespace Gtk
{
//: Displays help about widgets in the user interface.
//- The {\class Gtk::TipsQuery} widget is a subclass of {Gtk::Label::} which is used
//- to display help about widgets in a user interface.
//-
//- A query is started with a call to {start_query()}, usually when some kind of
//- 'Help' button is pressed. The {\class Gtk::TipsQuery} then grabs all
//- events, stopping the user interface from functioning normally. Then as the user
//- moves the mouse over the widgets, the {\class Gtk::TipsQuery} displays each
//- widget's tooltip text.
//-
//- By connecting to the "widget-entered" or "widget-selected" signals, it is
//- possible to customize the {\class Gtk::TipsQuery} to perform other actions when
//- widgets are entered or selected. For example, a help browser could be opened
//- with documentation on the widget selected.
//-
//- At some point a call to {stop_query()} must be made in order to stop the query
//- and return the interface to its normal state. The {set_caller()} function can be
//- used to specify a widget which the user can select to stop the query (often the
//- same button used to start the query).
class TipsQuery : public Label
{

public:
  typedef TipsQuery          CppObjectType;
  typedef TipsQuery_Class    CppClassType;
  typedef GtkTipsQuery           BaseObjectType;
  typedef GtkTipsQueryClass      BaseClassType;

private:
  friend class TipsQuery_Class;
  static CppClassType tips_query_class;

  TipsQuery(const TipsQuery&);
  TipsQuery& operator=(const TipsQuery&); // not implemented

protected:
  void   initialize_class();
  explicit TipsQuery(GtkTipsQuery *castitem);

public:
  static GtkType get_type();
  GtkTipsQuery* gtkobj()             { return (GtkTipsQuery*)(gtkobject); }
  const GtkTipsQuery* gtkobj() const { return (GtkTipsQuery*)(gtkobject); }
  static bool isA(Object *checkcast);

  // Hook for proxies
  static const char* const signal_names[];

  virtual ~TipsQuery();

private:

public:

  TipsQuery();



  //: Emitted when the query is started.

  //: Emitted when the query is stopped.


  //: Emitted when a widget is entered by the pointer while the query is in effect.



  //: Emitted when a widget is selected during a query.




  //: Sets the widget which initiates the query, usually a button.
  //- If the caller is selected while the query is running, the query is automatically stopped.
  //-
  //- {\var caller}: The widget which initiates the query.

  void set_caller(Gtk::Widget* caller=0);
  //: Sets the widget which initiates the query, usually a button.
  //- If the caller is selected while the query is running, the query is automatically stopped.
  //-
  //- {\var caller}: The widget which initiates the query.

  void set_caller(Gtk::Widget& caller);

  //: Sets the text to display when the query is not in effect, and the text to display when
  //: the query is in effect but the widget beneath the pointer has no tooltip.
  //- {\var label_inactive}: The text to display when the query is not running.
  //-
  //- {\var label_no_tip}: The text to display when the query is running but the widget beneath
  //- the pointer has no tooltip.



  void set_labels(const string& label_inactive,const string& label_no_tip);

public:

  union
    {
      CppObjectType * tips_query_self;
      Gtk::EmitProxySignal0<void,CppObjectType,BaseObjectType,0,&gtk_tips_query_start_query> start_query;
      Gtk::EmitProxySignal0<void,CppObjectType,BaseObjectType,1,&gtk_tips_query_stop_query> stop_query;
    };

protected:
  // impl functions
    virtual void start_query_impl();
    virtual void stop_query_impl();
    virtual void widget_entered_impl(Gtk::Widget* p0,const gchar* p1,const gchar* p2);
    virtual gint widget_selected_impl(Gtk::Widget* p0,const gchar* p1,const gchar* p2,GdkEventButton* p3);

};

}


#endif
