// NetRangerLog.cpp: implementation of the CNetRangerLog class.
//
//////////////////////////////////////////////////////////////////////
#include <stdio.h>
#include <string.h>
#include "IDSLog.h"
#include "NetRangerLog.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CNetRangerLog::CNetRangerLog()
{

}

CNetRangerLog::~CNetRangerLog()
{

}

void CNetRangerLog::IDSVersion (char *sIDSProduct, int& nIDSID, int& nIDSMajor, int& nIDSMinor, char *sIDSRev) const
{
	strcpy (sIDSProduct, "NetRanger");
	nIDSID = 4;
	nIDSMajor = 0;
	nIDSMinor = 0;
	sIDSRev[0] = '\0';
}

bool CNetRangerLog::LastIncident ()
{
	return feof (m_pLogFile) != 0;
}

// #Severity, timestamp (GMT), issueId, issueName, intruderIp, intruderName, victimIp, victimName, parameters, count

bool CNetRangerLog::ReadIncident ()
{
	char sLineBuffer[LOG_STRLEN + 1], sIP[16 + 1], sTmp[LOG_STRLEN + 1],
		sDate[LOG_STRLEN + 1], sTime[LOG_STRLEN + 1];
	int yr, mt, dy, hr, mn, sc;
	int ip1, ip2, ip3, ip4, nPort, rectype, nID, nSubID;

	while (!feof (m_pLogFile))
	{
		if (fgets (sLineBuffer, LOG_STRLEN, m_pLogFile) != sLineBuffer)
			break;

		int len = strlen (sLineBuffer);

		int i = 0;
		// recordtype field
		int n = 0;
		while (n < LOG_STRLEN)
		{
			if ((i < len) && (sLineBuffer[i] != ','))
				sTmp[n++] = sLineBuffer[i++];
			else
				break;
		}
		sTmp[n] = '\0';
		if (sscanf (sTmp, "%d", &rectype) == 1)
		{
			if (rectype != 4)
				continue;									// skip non-Event recordtypes
		}
		else
			continue;										// skip non-Event recordtypes
		while ((i < len) && (sLineBuffer[i] != ','))
			i++;
		i+=1;

		// skip recordid field
		while ((i < len) && (sLineBuffer[i] != ','))
			i++;
		i+=1;

		// GMT Datestamp field
		n = 0;
		while (n < LOG_STRLEN)
		{
			if ((i < len) && (sLineBuffer[i] != ','))
				sDate[n++] = sLineBuffer[i++];
			else
				break;
		}
		sDate[n] = '\0';
		int nDateParsed = sscanf (sDate, "%d/%d/%d", &yr, &mt, &dy);
		while ((i < len) && (sLineBuffer[i] != ','))
			i++;
		i+=1;

		// GMT Timestamp field
		n = 0;
		while (n < LOG_STRLEN)
		{
			if ((i < len) && (sLineBuffer[i] != ','))
				sTime[n++] = sLineBuffer[i++];
			else
				break;
		}
		sTime[n] = '\0';
		int nTimeParsed = sscanf (sTime, "%d:%d:%d", &hr, &mn, &sc);
		while ((i < len) && (sLineBuffer[i] != ','))
			i++;
		i+=1;

		if (nDateParsed == 3 && nTimeParsed == 3)
		{
			m_nDateTime = GetDate (yr, mt, dy, hr, mn, sc, 0);
		}
		else
			m_nDateTime = 0.0;
		
		// compare date
		if (m_nDateTime <= m_nStartDate)
		{
			m_bSkippedRecords = true;
			continue;
		}
		else if (m_nDateTime > m_nLastDate)
			m_nLastDate = m_nDateTime;


		// skip local Date/Timestamp, Application ID, Host ID, Org ID, Direction, Alarm fields
		for (int j = 0; j < 8; j++)
		{
			while ((i < len) && (sLineBuffer[i] != ','))
				i++;
			i+=1;
		}


		// id field
		n = 0;
		while (n < LOG_STRLEN)
		{
			if ((i < len) && (sLineBuffer[i] != ','))
				sTmp[n++] = sLineBuffer[i++];
			else
				break;
		}
		sTmp[n] = '\0';
		if (sscanf (sTmp, "%u", &nID) != 1)
			nID = 0;
		while ((i < len) && (sLineBuffer[i] != ','))
			i++;
		i+=1;

		// subsigid field. meaning depends on ID number.
		if (nID == 8000)
		{		
			n = 0;
			while (n < LOG_STRLEN)
			{
				if ((i < len) && (sLineBuffer[i] != ','))
					sTmp[n++] = sLineBuffer[i++];
				else
					break;
			}
			sTmp[n] = '\0';
			if (sscanf (sTmp, "%u", &nSubID) != 1)
				nSubID = 0;
		
			// build ID number
			if (nSubID)
				sprintf (m_sID, "%u-%u", nID, nSubID);
			else
				sprintf (m_sID, "%u", nID);
		}
		else
			sprintf (m_sID, "%u", nID);
		
		while ((i < len) && (sLineBuffer[i] != ','))
			i++;
		i+=1;


		// protocol field					<== ALWAYS TCP
		n = 0;
		while (n < LOG_STRLEN)
		{
			if ((i < len) && (sLineBuffer[i] != ','))
				sTmp[n++] = sLineBuffer[i++];
			else
				break;
		}
		sTmp[n] = '\0';
		if (strcmp (sTmp, "TCP/IP") == 0)
			m_nProtocol = PROTO_TCP;
		else
			m_nProtocol = 0;

		while ((i < len) && (sLineBuffer[i] != ','))
			i++;
		i+=1;

		// src IP field
		n = 0;
		while (n < 16)
		{
			if ((i < len) && (sLineBuffer[i] != ','))
				sIP[n++] = sLineBuffer[i++];
			else
				break;
		}
		sIP[n] = '\0';
		if (sscanf (sIP, "%d.%d.%d.%d", &ip1, &ip2, &ip3, &ip4) == 4)
		{
			unsigned char *octets = (unsigned char *)&m_nFromIP;
			octets[0] = (unsigned char) (ip1 & 0xff);
			octets[1] = (unsigned char) (ip2 & 0xff);
			octets[2] = (unsigned char) (ip3 & 0xff);
			octets[3] = (unsigned char) (ip4 & 0xff);
		}
		else
			m_nFromIP = 0;
		while ((i < len) && (sLineBuffer[i] != ','))
			i++;
		i+=1;

		// dest IP field
		n = 0;
		while (n < 16)
		{
			if ((i < len) && (sLineBuffer[i] != ','))
				sIP[n++] = sLineBuffer[i++];
			else
				break;
		}
		sIP[n] = '\0';
		if (sscanf (sIP, "%d.%d.%d.%d", &ip1, &ip2, &ip3, &ip4) == 4)
		{
			unsigned char *octets = (unsigned char *)&m_nToIP;
			octets[0] = (unsigned char) (ip1 & 0xff);
			octets[1] = (unsigned char) (ip2 & 0xff);
			octets[2] = (unsigned char) (ip3 & 0xff);
			octets[3] = (unsigned char) (ip4 & 0xff);
		}
		else
			m_nToIP = 0;
		while ((i < len) && (sLineBuffer[i] != ','))
			i++;
		i+=1;

		// fromport field
		n = 0;
		while (n < LOG_STRLEN)
		{
			if ((i < len) && (sLineBuffer[i] != ','))
				sTmp[n++] = sLineBuffer[i++];
			else
				break;
		}
		sTmp[n] = '\0';
		if (sscanf (sTmp, "%d", &nPort) == 1)
			m_nFromPort = nPort;
		else
			m_nFromPort = 0;
		while ((i < len) && (sLineBuffer[i] != ','))
			i++;
		i+=1;

		// toport field
		n = 0;
		while (n < LOG_STRLEN)
		{
			if ((i < len) && (sLineBuffer[i] != ','))
				sTmp[n++] = sLineBuffer[i++];
			else
				break;
		}
		sTmp[n] = '\0';
		if (sscanf (sTmp, "%d", &nPort) == 1)
			m_nToPort = nPort;
		else
			m_nToPort = 0;

		m_nCount = 1;

		return true;
	}

	return false;
}

void CNetRangerLog::CloseLog ()
{
	fclose (m_pLogFile);
}

bool CNetRangerLog::OpenLog (const char *filename)
{
	m_pLogFile = fopen (filename, "r");
	m_bSkippedRecords = false;
	return m_pLogFile != NULL;
}

void CNetRangerLog::SeekLog (double nDate)
{
	m_nStartDate = nDate;
	m_nLastDate = nDate;
}

double CNetRangerLog::GetLastDate ()
{
	return m_nLastDate;
}
