///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
 *	OPCODE - Optimized Collision Detection
 *	Copyright (C) 2001 Pierre Terdiman
 *	Homepage: http://www.codercorner.com/Opcode.htm
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	Contains code for 3x3 matrices.
 *	\file		OPC_Matrix3x3.h
 *	\author		Pierre Terdiman
 *	\date		April, 4, 2000
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Include Guard
#ifndef __ICEMATRIX3X3_H__
#define __ICEMATRIX3X3_H__

	class OPCODE_API Matrix3x3
	{
		public:
		//! Empty constructor
		__forceinline				Matrix3x3()									{}
		//! Constructor from 9 values
		__forceinline				Matrix3x3(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22)
									{
										m[0][0] = m00;	m[0][1] = m01;	m[0][2] = m02;
										m[1][0] = m10;	m[1][1] = m11;	m[1][2] = m12;
										m[2][0] = m20;	m[2][1] = m21;	m[2][2] = m22;
									}
		//! Copy constructor
		__forceinline				Matrix3x3(const Matrix3x3& mat)				{ CopyMemory(m, &mat.m, 9*sizeof(float));	}
		//! Destructor
		__forceinline				~Matrix3x3()								{}

		//! Access as rows
		__forceinline	const Point*	operator[](int nRow)	const	{ return (const Point*)&m[nRow][0];	}
		//! Access as rows
		__forceinline	Point*			operator[](int nRow)			{ return (Point*)&m[nRow][0];		}

		public:
						float		m[3][3];		//!< Array of 9 floats
	};

#endif // __ICEMATRIX3X3_H__

// END-OF-FILE\n
