/*
 * Copyright (c) 2001,2002 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __SOCKET_H__
#define __SOCKET_H__

#include <qtextstream.h>
#include <qsocket.h>
#include <stdio.h>
#include <qfile.h>
#include <qcstring.h>

#include "waitdlg.h"

/*========================================================*/

class ArsonSocket : public QSocket
{
	Q_OBJECT
	
public:
	ArsonSocket (const QString &host, short port);

	bool hasError (void) const { return (m_errCode != 0); }
	int errorCode (void) const { return m_errCode; }

protected:
	virtual void dispatch (const char *data, int nbytes);
	virtual void done (void);

private:
	int m_errCode;

protected slots:
	virtual void slotError (int errCode);
	virtual void slotConnected (void);
	virtual void slotClosed (void);
	virtual void slotRead (void);

signals:
	virtual void complete (ArsonSocket *pThis);
};

/*========================================================*/

class ArsonTempFile;

class ArsonRetrSocket : public ArsonSocket
{
public:
	ArsonRetrSocket (const QString &host, short port);
	virtual ~ArsonRetrSocket (void);

	const ArsonTempFile &tempFile (void) const { return *m_tempFile; }
	ArsonTempFile &tempFile (void) { return *m_tempFile; }

	QString tempName (void);

protected:
	virtual void dispatch (const char *data, int nbytes);
	virtual void done (void);

private:
	ArsonTempFile *m_tempFile;
};

/*========================================================*/

class ArsonSendSocket : public ArsonSocket
{
	Q_OBJECT
	
public:
	ArsonSendSocket (const QString &host, short port);

	bool sendFile (const char *filename, uint blockSize = 1024);

protected:
	virtual void slotConnected (void);
	virtual void sendComplete (void);

	void refillBuffer (void);

	QByteArray m_buf;
	QString m_host;
	short m_port;
	QFile m_file;
	uint m_blockSize;

protected slots:
	virtual void slotBytesWritten (int bytes);
};

/*========================================================*/

class ArsonHttpGetSocket : public ArsonRetrSocket
{
public:
	ArsonHttpGetSocket (const QString &host, short port = 80);

protected:
	virtual QString path (void) const = 0;
	virtual QString request (void) const
	{ return QString::null; }
	
	virtual void slotConnected (void);
};

/*========================================================*/

class ArsonHttpPostSocket : public ArsonSendSocket
{
public:
	ArsonHttpPostSocket (const QString &host, short port = 80);

protected:
	virtual void response (int code, const QString &msg) { }
	virtual QString path (void) const = 0;
	virtual void slotConnected (void);
	virtual void slotRead (void);
	virtual void sendComplete (void);
};

/*========================================================*/

class ArsonHttpStream : public QTextStream
{
public:
	ArsonHttpStream (FILE *file);
	virtual ~ArsonHttpStream (void);

private:
	FILE *m_file;
};

/*========================================================*/

class ArsonHttpCommand
{
public:
	ArsonHttpCommand (const QString &cmd = QString::null);

	ArsonHttpCommand &operator<< (const ArsonHttpCommand &rhs);
	ArsonHttpCommand &operator<< (const QString &text);
	ArsonHttpCommand &operator<< (uint n);
	ArsonHttpCommand &operator<< (int n);

	QString command (void) const { return m_command; }

	void setCommand (const QString &cmd);
	
protected:
	QString m_command;
};

/*========================================================*/

class ArsonSocketWaitDlg : public ArsonWaitDlg
{
	Q_OBJECT
	
public:
	ArsonSocketWaitDlg (void);
	virtual ~ArsonSocketWaitDlg (void);
	
	virtual int exec (void);

protected:
	virtual ArsonSocket *createSocket (void) = 0;

	void beginConnection (const char *slot = NULL);

	ArsonSocket *m_pSocket;

protected slots:
	virtual void slotCompleted (ArsonSocket *pThis);
};

/*========================================================*/
#endif	/*	__SOCKET_H__	*/
