/*
     This file is part of Advanced Strategic Command; http://www.asc-hq.de
     Copyright (C) 1994-2008  Martin Bickel  and  Marc Schellenberger
 
     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     (at your option) any later version.
 
     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.
 
     You should have received a copy of the GNU General Public License
     along with this program; see the file COPYING. If not, write to the 
     Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
     Boston, MA  02111-1307  USA
*/


#ifndef destructContainerH
#define destructContainerH


#include "containeraction.h"

#include "../typen.h"

class DestructContainer : public ContainerAction {
   
      bool building;  

      //! saves if the unit was registered on the field
      enum FieldRegistration { NONE, FIRST, SECOND, CARRIER } fieldRegistration;

      tmemorystreambuf* unitBuffer;
      
      int hostingCarrier;
      int cargoSlot;
      bool suppressWreckage;
      
      DestructContainer( GameMap* map ) : ContainerAction( map ), unitBuffer(NULL), hostingCarrier(0), cargoSlot(-1), suppressWreckage(false) {};
      template<class Child> friend GameAction* GameActionCreator( GameMap* map);
     
   public:
      DestructContainer( ContainerBase* container, bool suppressWreckage = false );
      
      ASCString getDescription() const;
      
      ~DestructContainer();
      
   protected:
      virtual GameActionID getID() const;
      
      virtual ActionResult runAction( const Context& context );
      virtual ActionResult undoAction( const Context& context );
      
      virtual void readData ( tnstream& stream );
      virtual void writeData ( tnstream& stream ) const;
      
};

#endif

