#include <asdlib.h>

int main(int argc, char *argv[])
{
  AsdConnection *c;
  gchar version[256];

  if (!(c = asd_connection_new(NULL)))
    {
      asd_perror("Could not create connection");
      return -1;
    }
  
  if (!asd_server_version(c, version, sizeof(version)))
    {
      asd_perror("Could not query version");
      asd_connection_free(c);
      return -2;
    }

  asd_connection_free(c);

  g_print("%s\n", version);

  return 0;
}
