#include <unistd.h>
#include <fcntl.h>
#include <glib.h>
#include <string.h>
#include <pthread.h>
#include <signal.h>

#include <asdutil.h>
#include <esound-auth.h>

#include <thread-manager.h>

#include "protocol-esound.h"
#include "idgen.h"
#include "protocol-esound-impl.h"

gboolean protocol_esound_auth_locked = TRUE;

void protocol_esound_dispatch(int fd)
{
  ProtocolEsoundClient client;
  ProtocolEsoundAuthenticate auth;
  guint32 ok = 1;

  client.fd = fd;
  client.id = generate_id();

  if (atomic_read(client.fd, &auth, sizeof(auth)) == sizeof(auth))
    if (!protocol_esound_auth_locked || (esound_auth_cookie_available && esound_auth_compare_cookie(auth.cookie)))
      if (atomic_write(client.fd, &ok, sizeof(ok)) == sizeof(ok))
	{
	  if (auth.swap != ESD_ENDIAN_KEY && auth.swap != ESD_SWAP_ENDIAN_KEY)
	    g_message("ESOUND: Broken endianess.");
	  else
	    {
	      client.swap = auth.swap == ESD_SWAP_ENDIAN_KEY;
	  
	      for (;;)
		{
		  ProtocolEsoundCommand c;
		  ProtocolEsoundHandler *h;
		  gint r;
		  
		  if (atomic_read(client.fd, &c, sizeof(c)) != sizeof(c))
		    break;
		  
		  if (!(h = protocol_esound_find_handler(c)))
		    {
		      g_message("ESOUND: Called unsupported function: %i", (int) c);
		      break;
		    }

		  g_assert(h->proc);
		  
		  r = h->proc(&client, c);
		  
		  if (r == 1) return;
		  if (r == 2) break;
		}
	    }
	}

  close(client.fd);
}

static void _protocol_esound_thread_cleanup(gpointer p)
{
  thread_unregister(pthread_self());
  close(*((int*)p));
}

static void* _protocol_esound_thread(void *p)
{
  sigset_t ss;
  int fd;

  g_assert(p);
  fd = *((int*)p);
  g_free(p);

  thread_register(pthread_self());
  pthread_cleanup_push(_protocol_esound_thread_cleanup, p);

  pthread_sigmask(SIG_BLOCK, NULL, &ss);
  sigaddset(&ss, SIGINT);
  sigaddset(&ss, SIGQUIT);
  //  sigaddset(&ss, SIGHUP);
  pthread_sigmask(SIG_BLOCK, &ss, NULL);

  pthread_setcanceltype(PTHREAD_CANCEL_DEFERRED, NULL);
  pthread_setcancelstate(PTHREAD_CANCEL_ENABLE, NULL);

  protocol_esound_dispatch(fd);

  pthread_cleanup_pop(0);
  thread_unregister(pthread_self());

  pthread_detach(pthread_self());

  return NULL;
}

void protocol_esound_new_socket(int fd)
{
  pthread_t t;
  g_assert(fd >= 0);
  g_assert(!pthread_create(&t, NULL, _protocol_esound_thread, g_memdup(&fd, sizeof(int))));
}


