------------------------------------------------------------------------------
--                                                                          --
--                            GNATPP COMPONENTS                             --
--                                                                          --
--                    G N A T P P . P A R A G R A P H S                     --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                    Copyright (C) 2001-2005, AdaCore                      --
--                                                                          --
-- GNATPP is free software; you can redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNATPP is  distributed in the  hope that it will  be  useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or  FITNESS  FOR A  PARTICULAR  PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write  to  the Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston,                                                                  --
--                                                                          --
-- GNATPP is maintained by AdaCore (http://www.adacore.com)                 --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains the routines used to detect and to control the
--  alignment in paragraphs

with Asis; use Asis;

package GNATPP.Paragraphs is

   procedure Compute_Alignment_In_Paragraphs (E : Asis.Element);
   --  Should be applied to constructs which have sequence of declarations and
   --  sequence of statements as their top-level structural components. This
   --  procedure scans the top-level declaration and statement sequences,
   --  detect the "paragraphs" for which the colon or/and assignment signs
   --  alignment is possible. It computes the alignment and stores the results
   --  in the Alignment_Stack.

   procedure Compute_Alignment_In_Context_Clause
     (Clause_Elements : Asis.Element_List);
   --  Should be applied to the full list of context clause elements. Computes
   --  the alignment of use clauses in 'with - use' pairs.

   procedure Save_Paragraph;
   procedure Restore_Paragraph;
   --  In case when we have one declaration or statement sequence enclosed in
   --  another sequence, we use the first procedure to store the pointer
   --  to the paragraph alignment record in enclosing sequence when entering
   --  the enclosed sequence, and we use the second procedure to restore this
   --  pointer when leaving the enclosed sequence.

   procedure Move_No_Next_Paragraph;
   --  Moves the paragraph alignment record pointer when entering the next
   --  paragraph (in the same sequence).

   In_Paragraph : Boolean := False;
   --  This flag shows if the previous construct was a part of a paragraph
   --  When this flag changes this value from False to true, the pointer
   --  to the next paragraph alignment record is move ahead

   Colon_In_Paragraph  : Natural := 0;
   Use_In_Paragraph    : Natural renames Colon_In_Paragraph;
   At_In_Paragraph     : Natural renames Colon_In_Paragraph;
   Assign_In_Paragraph : Natural := 0;
   --  Alignment in the current paragraph

   procedure Set_New_Paragraph;
   --  Is called when in the general source traversal we enter a new
   --  declaration or statement paragraph. Moves ahead the pointer to the
   --  paragraph alignment info; sets In_Paragraph ON, sets Colon_In_Paragraph
   --  and Colon_In_Paragraph

   procedure Set_No_Paragraph;
   --  Sets all the parameter-specific alignment OFF

end GNATPP.Paragraphs;
