------------------------------------------------------------------------------
--                                                                          --
--                          GNATCHECK COMPONENTS                            --
--                                                                          --
--                     G N A T S Y N C . O P T I O N S                      --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                    Copyright (C) 2007-2008, AdaCore                      --
--                                                                          --
-- GNATSYNC  is  free  software;  you  can redistribute it and/or modify it --
-- under terms of the  GNU  General Public License as published by the Free --
-- Software Foundation;  either version 2, or ( at your option)  any  later --
-- version.  GNATCHECK  is  distributed in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General Public License distributed with GNAT; see file  COPYING. If --
-- not,  write to the  Free Software Foundation,  51 Franklin Street, Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
--                                                                          --
-- GNATSYNC is maintained by AdaCore (http://www.adacore.com).              --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines the gnatsync-specific options

with GNAT.OS_Lib; use GNAT.OS_Lib;

package Gnatsync.Options is

   Main_Subprogram_Name : String_Access;
   --  -main=<name of the main subprogram>
   --  The name of the source file containing the main subprogram. The name
   --  may or may not contain the suffix. This subprogram, is called by the
   --  environment task.

   type Output_Levels is
     (Brief,
      --  only nodes to which unprotected unsynchronized access is possible are
      --  reported
      Medium,
      --  for each node, reports the list of tasks that reads from/writes into
      --  the node. In case of the direct access, the SLOC of the access is
      --  printed out. In case of indirect access only the name and the SLOC
      --  of the body of the accessing task is reported
      Full);
      --  Medium + full backtraces for inderect access);

   Output_Level : Output_Levels := Medium;
   --  -o(b|m|f)
   --  Output detalization level

   Foreign_Threads_Present : Boolean := False;
   --  Indicates if non-Ada threads should be analyzed

   Foreign_Critical_Sections_Present : Boolean := False;
   --  Indicates if non-Ada critical sections should be skipped when analyzing
   --  call graph and data access.
end Gnatsync.Options;
