@echo off

if .%1. == .. goto install
if .%1. == .all. goto install
if .%1. == .clean. goto clean

goto help

:install

rem --  You have to edit the next two lines, if you would like to install
rem --  ASIS in location different from c:\local\asis

set INSTALL_DRIVE=c:
set INSTALL_DIR=local

set ADA_INCLUDE_PATH=
set ADA_OBJECTs_PATH=

rem --  we have to start from the top directory of the unpacked ASIS distribution
rem --  named asis-[version#]

rem --  go into obj subdirectory and compile everything
cd obj
gnatmake -c -I../gnat -I../asis -g -O2 install_asis.adb

rem --  we do not need object and ali file created for a dummy
rem --  Install_ASIS procedure

del install_asis.o install_asis.ali

rem --  creating a library file
ar rc libasis.a *.o
ranlib libasis.a

rem --  and moving all the installation stuff into C:\local\asis

rem --  first, cleaning up the location for the ASIS library installation:

mkdir %INSTALL_DRIVE%\%INSTALL_DIR%

mkdir %INSTALL_DRIVE%\%INSTALL_DIR%\asis

if errorlevel 0 goto err1
   del %INSTALL_DRIVE%\%INSTALL_DIR%\asis /s /f /q
:err1

move *.ali         %INSTALL_DRIVE%\%INSTALL_DIR%\asis
move libasis.a     %INSTALL_DRIVE%\%INSTALL_DIR%\asis
del  *.o

copy ..\asis\*.ads %INSTALL_DRIVE%\%INSTALL_DIR%\asis
copy ..\asis\*.adb %INSTALL_DRIVE%\%INSTALL_DIR%\asis
copy ..\gnat\*.ads %INSTALL_DRIVE%\%INSTALL_DIR%\asis
copy ..\gnat\*.adb %INSTALL_DRIVE%\%INSTALL_DIR%\asis

rem --  locking the ALI files of the ASIS library
attrib +r          %INSTALL_DRIVE%\%INSTALL_DIR%\asis\*.ali

set ADA_INCLUDE_PATH=%INSTALL_DRIVE%\%INSTALL_DIR%\asis
set ADA_OBJECTS_PATH=%INSTALL_DRIVE%\%INSTALL_DIR%\asis

rem --  ASIStant is considered as a part of a standard ASIS installation

cd ..\tools\asistant
gnatmake -g -O2 -o asistant asistant-driver.adb -largs -lasis
cd ..\..

if .%1. == .all. goto create_examples
goto done

: create_examples
rem --  creating ASIS tools and examples

cd tools

cd gnatstub
gnatmake -g -O2 -o gnatstub gnatstub-driver.adb -largs -lasis

cd ..\gnatelim
gnatmake -g -O2 -o gnatelim gnatelim-driver.adb -largs -lasis

cd ..\..\examples\ds
gnatmake -g -O2 -o ds display_source.adb -largs -lasis
cd ..

cd ..

goto done

:clean

cd tools\asistant
del *.o
del *.ali
del *.exe
del b_*.c
del b~*.ad*
cd ..

cd gnatelim
del *.o
del *.ali
del *.exe
del b_*.c
del b~*.ad*
cd ..

cd gnatstub
del *.o
del *.ali
del *.exe
del b_*.c
del b~*.ad*
cd ..

cd ..\examples

cd ds
del *.o
del *.ali
del *.exe
del b_*.c
del b~*.ad*
cd ..

cd ..

goto done

:help
echo Usage: asis_install [options]
echo        options: all   - install ASIS and build all the tools and examples
echo                 clean - clean up ASIS examples source directories


goto fin

:done
set INSTALL_DRIVE =
set INSTALL_DIR   =

:fin