/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.reporting;

import java.io.File;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.reporting.ComplexityCalculator;
import net.sourceforge.cobertura.reporting.html.HTMLReport;
import net.sourceforge.cobertura.reporting.xml.XMLReport;
import net.sourceforge.cobertura.util.CommandLineBuilder;
import net.sourceforge.cobertura.util.FileFinder;
import net.sourceforge.cobertura.util.Header;
import org.apache.log4j.Logger;

public class Main {
    private static final Logger LOGGER = Logger.getLogger((Class)(class$net$sourceforge$cobertura$reporting$Main == null ? (class$net$sourceforge$cobertura$reporting$Main = Main.class$("net.sourceforge.cobertura.reporting.Main")) : class$net$sourceforge$cobertura$reporting$Main));
    private String format = "html";
    private File dataFile = null;
    private File destinationDir = null;
    static /* synthetic */ Class class$net$sourceforge$cobertura$reporting$Main;

    private void parseArguments(String[] args) throws Exception {
        ProjectData projectData;
        FileFinder finder = new FileFinder();
        String baseDir = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("--basedir")) {
                baseDir = args[++i];
            } else if (args[i].equals("--datafile")) {
                this.setDataFile(args[++i]);
            } else if (args[i].equals("--destination")) {
                this.setDestination(args[++i]);
            } else if (args[i].equals("--format")) {
                this.setFormat(args[++i]);
            } else if (baseDir == null) {
                finder.addSourceDirectory(args[i]);
            } else {
                finder.addSourceFile(baseDir, args[i]);
            }
            ++i;
        }
        if (this.dataFile == null) {
            this.dataFile = CoverageDataFileHandler.getDefaultDataFile();
        }
        if (this.destinationDir == null) {
            System.err.println("Error: destination directory must be set");
            System.exit(1);
        }
        if (this.format == null) {
            System.err.println("Error: format must be set");
            System.exit(1);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("format is " + this.format));
            LOGGER.debug((Object)("dataFile is " + this.dataFile.getAbsolutePath()));
            LOGGER.debug((Object)("destinationDir is " + this.destinationDir.getAbsolutePath()));
        }
        if ((projectData = CoverageDataFileHandler.loadCoverageData(this.dataFile)) == null) {
            System.err.println("Error: Unable to read from data file " + this.dataFile.getAbsolutePath());
            System.exit(1);
        }
        ComplexityCalculator complexity = new ComplexityCalculator(finder);
        if (this.format.equalsIgnoreCase("html")) {
            new HTMLReport(projectData, this.destinationDir, finder, complexity);
        } else if (this.format.equalsIgnoreCase("xml")) {
            new XMLReport(projectData, this.destinationDir, finder, complexity);
        }
    }

    private void setFormat(String value) {
        this.format = value;
        if (!this.format.equalsIgnoreCase("html") && !this.format.equalsIgnoreCase("xml")) {
            System.err.println("Error: format \"" + this.format + "\" is invalid. Must be either html or xml");
            System.exit(1);
        }
    }

    private void setDataFile(String value) {
        this.dataFile = new File(value);
        if (!this.dataFile.exists()) {
            System.err.println("Error: data file " + this.dataFile.getAbsolutePath() + " does not exist");
            System.exit(1);
        }
        if (!this.dataFile.isFile()) {
            System.err.println("Error: data file " + this.dataFile.getAbsolutePath() + " must be a regular file");
            System.exit(1);
        }
    }

    private void setDestination(String value) {
        this.destinationDir = new File(value);
        if (this.destinationDir.exists() && !this.destinationDir.isDirectory()) {
            System.err.println("Error: destination directory " + this.destinationDir + " already exists but is not a directory");
            System.exit(1);
        }
        this.destinationDir.mkdirs();
    }

    public static void main(String[] args) throws Exception {
        Header.print(System.out);
        long startTime = System.currentTimeMillis();
        Main main = new Main();
        try {
            args = CommandLineBuilder.preprocessCommandLineArguments(args);
        }
        catch (Exception ex) {
            System.err.println("Error: Cannot process arguments: " + ex.getMessage());
            System.exit(1);
        }
        main.parseArguments(args);
        long stopTime = System.currentTimeMillis();
        System.out.println("Report time: " + (stopTime - startTime) + "ms");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

