/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xslt;

import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Language;
import gnu.expr.ModuleBody;
import gnu.expr.QuoteExp;
import gnu.kawa.xml.Document;
import gnu.kawa.xml.Focus;
import gnu.kawa.xml.KDocument;
import gnu.kawa.xslt.TemplateTable;
import gnu.kawa.xslt.XslTranslator;
import gnu.lists.Consumer;
import gnu.lists.TreeList;
import gnu.mapping.CallContext;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.InPort;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import gnu.xquery.lang.XQParser;
import gnu.xquery.lang.XQuery;
import java.io.IOException;
import java.util.Vector;
import kawa.repl;

public class XSLT
extends XQuery {
    public static XSLT instance;
    public static Symbol nullMode;

    public String getName() {
        return "XSLT";
    }

    public XSLT() {
        instance = this;
        ModuleBody.setMainPrintValues(true);
    }

    public static XSLT getXsltInstance() {
        if (instance == null) {
            new XSLT();
        }
        return instance;
    }

    Expression parseXPath(String string, SourceMessages messages) {
        try {
            Expression sexp;
            Compilation tr = new Compilation(this, messages);
            XQParser parser = (XQParser)super.getLexer(new CharArrayInPort(string), messages);
            Vector<Expression> exps = new Vector<Expression>(20);
            while ((sexp = parser.parse(tr)) != null) {
                exps.addElement(sexp);
            }
            int nexps = exps.size();
            if (nexps == 0) {
                return QuoteExp.voidExp;
            }
            if (nexps == 1) {
                return (Expression)exps.elementAt(0);
            }
            throw new InternalError("too many xpath expressions");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new InternalError("caught " + ex);
        }
    }

    public Lexer getLexer(InPort inp, SourceMessages messages) {
        return new XslTranslator(inp, messages, this);
    }

    public Compilation getCompilation(Lexer lexer, SourceMessages messages) {
        return new Compilation(this, messages);
    }

    public boolean parse(Compilation comp, int options) throws IOException, SyntaxException {
        Compilation.defaultCallConvention = 2;
        ((XslTranslator)comp.lexer).parse(comp);
        return true;
    }

    public static void registerEnvironment() {
        Language.setDefaults(new XSLT());
    }

    public static void defineCallTemplate(Symbol name, double priority, Procedure template) {
    }

    public static void defineApplyTemplate(String pattern, double priority, Symbol mode, Procedure template) {
        if (mode == null) {
            mode = nullMode;
        }
        TemplateTable table = TemplateTable.getTemplateTable(mode);
        table.enter(pattern, priority, template);
    }

    public static void defineTemplate(Symbol name, String pattern, double priority, Symbol mode, Procedure template) {
        if (name != null) {
            XSLT.defineCallTemplate(name, priority, template);
        }
        if (pattern != null) {
            XSLT.defineApplyTemplate(pattern, priority, mode, template);
        }
    }

    public static void process(TreeList doc, Focus pos, CallContext ctx) throws Throwable {
        Consumer out = ctx.consumer;
        while (true) {
            int ipos = pos.ipos;
            int kind = doc.getNextKind(ipos);
            switch (kind) {
                case 34: {
                    ipos = doc.firstChildPos(ipos);
                    break;
                }
                case 33: {
                    Object type = pos.getNextTypeObject();
                    Procedure proc = TemplateTable.nullModeTable.find(pos.getNextTypeName());
                    String name = pos.getNextTypeName();
                    if (proc != null) {
                        proc.check0(ctx);
                        ctx.runUntilDone();
                    } else {
                        out.startElement(type);
                        pos.push(doc, doc.firstChildPos(ipos));
                        XSLT.process(doc, pos, ctx);
                        pos.pop();
                        out.endElement();
                    }
                    ipos = doc.nextDataIndex(ipos >>> 1) << 1;
                    pos.gotoNext();
                    break;
                }
                case 29: {
                    int ichild = ipos >>> 1;
                    int next = doc.nextNodeIndex(ichild, Integer.MAX_VALUE);
                    if (ipos == next) {
                        next = doc.nextDataIndex(ichild);
                    }
                    doc.consumeIRange(ichild, next, out);
                    ipos = next << 1;
                    break;
                }
                default: {
                    return;
                }
            }
            pos.ipos = ipos;
        }
    }

    public static void runStylesheet() throws Throwable {
        CallContext ctx = CallContext.getInstance();
        String[] args = repl.commandLineArgArray;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            KDocument doc = Document.parse(arg);
            Focus pos = Focus.getCurrent();
            pos.push(doc.sequence, doc.ipos);
            XSLT.process((TreeList)doc.sequence, pos, ctx);
        }
    }

    public static void applyTemplates(String select, Symbol mode) throws Throwable {
        if (mode == null) {
            mode = nullMode;
        }
        TemplateTable table = TemplateTable.getTemplateTable(mode);
        CallContext ctx = CallContext.getInstance();
        Focus pos = Focus.getCurrent();
        TreeList doc = (TreeList)pos.sequence;
        pos.push(doc, doc.firstChildPos(pos.ipos));
        XSLT.process(doc, pos, ctx);
        pos.pop();
    }

    static {
        nullMode = Symbol.make(null, "");
    }
}

