// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __Signature_h__
#define __Signature_h__

#include "Puma/Array.h"

namespace Puma {


class Signature {
  const char *_type;
  const char *_name;
  Array<const char*> _argv;
  unsigned _argc;
  bool _method;
   
  static void translate_multiword_identifiers (char *);
  void parse (const char *);

public:
  Signature (const char *);
   
  const char *name ();
  const char *type ();
  const char *argv (int);
  unsigned argc ();
  bool method ();
};


} // namespace Puma

#endif /* __Signature_h__ */
