// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#include "Puma/ACSliceInfo.h"
#include "Puma/ACTree.h"
#include "Puma/CClassDatabase.h"

namespace Puma {

ACSliceInfo::Type ACSliceInfo::type () const {
  if (!_def_node)
    return SL_UNKNOWN;
  switch (_def_node->key ()->token ()->type ()) {
    case TOK_UNION:  return SL_UNION;
    case TOK_STRUCT: return SL_STRUCT;
    case TOK_CLASS:  return SL_CLASS;
    case TOK_ASPECT: return SL_ASPECT;
    default:
      return SL_UNKNOWN;
  }
}

ACSliceInfo *ACSliceInfo::definition () const {
  CObjectInfo *curr = _object;
  do {
    CT_ClassSliceDecl *csd = (CT_ClassSliceDecl*)curr->Tree ();
    if (csd->members () || csd->base_clause ())
      return curr->ClassDB ()->SliceInfo (curr);
    curr = curr->NextObject ();
  } while (curr != _object);
  return (ACSliceInfo*)0;
}

} // namespace Puma
