// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#include "Puma/SimpleParser.h"

namespace Puma {


string SimpleParser::strip (const string &str) {
  if (str[0] == '"' && str[str.length () - 1] == '"')
    return str.substr (1, str.length () - 2);
  return str;
}


int SimpleParser::tokenize (const string &line, vector<string> &words, 
 const string &delimiters) {
  int res=0;
  // Skip delimiters at beginning.
  string::size_type lastPos = line.find_first_not_of (delimiters, 0);
  // Find first "delimiter".
  string::size_type pos     = line.find_first_of (delimiters, lastPos);
  // Find first '"'
  string::size_type hpos    = line.find_first_of ('"', lastPos);

  if (hpos != string::npos && hpos < pos)
    // Find next "delimiter" after closing '"'
    pos = line.find_first_of (delimiters, line.find_first_of ('"', hpos + 1) + 1);

  while ((string::npos != pos) || (string::npos != lastPos)) {
    string token = line.substr (lastPos, pos - lastPos);
    // strip '"'
    //if (token[0] == '"' && token[token.length () - 1] == '"')
    //  token = token.substr (1, token.length () - 2);
    // Found a token, add it to the vector.
    words.push_back (token);
    res++;
    // Skip delimiters.  Note the "not_of"
    lastPos = line.find_first_not_of (delimiters, pos);
    // Find next "non-delimiter"
    pos = line.find_first_of (delimiters, lastPos);
    // Find first '"'
    hpos = line.find_first_of ('"', lastPos);
    if (hpos != string::npos && hpos < pos)
      // Find next "delimiter" after closing '"'
      pos = line.find_first_of (delimiters, line.find_first_of ('"', hpos + 1) + 1);
  }
  return res;
}


} // namespace Puma
