#ifndef __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#define __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#define __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CScopeInfo_h__

#ifndef __ac_h_
#define __ac_h_
namespace AC {
  typedef const char* Type;
  enum JPType { CALL = 0x0004, EXECUTION = 0x0008, CONSTRUCTION = 0x0010, DESTRUCTION = 0x0020 };
  struct Action {
    void **_args; void *_result; void *_target; void *_that; void *_fptr;
    void (*_wrapper)(Action &);
    inline void trigger () { _wrapper (*this); }
  };
  struct AnyResultBuffer {};
  template <typename T> struct ResultBuffer : public AnyResultBuffer {
    char _data[sizeof (T)];
    ~ResultBuffer () { ((T*)_data)->T::~T(); }
    operator T& () const { return *(T*)_data; }
  };
  template <class Aspect, int Index>
  struct CFlow {
    static int &instance () {
      static int counter = 0;
      return counter;
    }
    CFlow () { instance ()++; }
    ~CFlow () { instance ()--; }
    static bool active () { return instance () > 0; }
  };
}
inline void * operator new (__SIZE_TYPE__, AC::AnyResultBuffer *p) { return p; }
inline void operator delete (void *, AC::AnyResultBuffer *) { } // for VC++
#endif // __ac_h_
#endif // __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CScopeInfo_h__
#define __CScopeInfo_h__

// scope info

#include "Puma/CObjectInfo.h"
#include "Puma/Array.h"

namespace Puma {


class CLocalScope;
class CFunctionInfo;
class CNamespaceInfo;
class CClassInfo;
class CUnionInfo;
class CTemplateInfo;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class CScopeInfo : public CObjectInfo {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  Array<CScopeInfo*> _Children; // child scopes
  CScopeInfo *_Parent; // parent scope
 
protected:
  CScopeInfo (ObjectId);

public:
  ~CScopeInfo ();

  // Get ... 
  unsigned Children () const;           // children of this scope
  CScopeInfo *Child (unsigned) const;
  CScopeInfo *Parent () const;          // parent scope
  bool isFile () const;                 // is file?
  bool isNamespace () const;            // is namespace?
  bool isRecord () const;               // is class or union?
  bool isClass () const;                // is class?
  bool isUnion () const;                // is union?
  bool isFunction () const;             // is function?
  bool isMethod () const;               // is class method?
  bool isClassTemplate () const;        // is class template?
  bool isFctTemplate () const;          // is function template?
  bool insideTemplate () const;         // is inside class or function template?
  bool insideRecord () const;           // is inside class or union?
  bool insideClass () const;            // is inside class?
  bool insideUnion () const;            // is inside union?
  bool insideFunction () const;         // is inside function?
  bool insideMethod () const;           // is inside class method?
  bool isLocalScope () const;           // is local (block) scope?
  bool isLocalRecord () const;          // is local (block scope) class or union?
  bool isLocalClass () const;           // is local (block scope) class?
  bool isLocalUnion () const;           // is local (block scope) union?
  
  bool GlobalScope () const;            // global (file) scope

  // Set ...
  void Parent (const CScopeInfo *);
  void addChild (CScopeInfo *);
  void removeChild (const CScopeInfo *); // WILL NOT BE DESTROYED!
  
  // Create/Delete ...
  CLocalScope *newLocalScope ();
  CFunctionInfo *newFunction (bool = false);
  CClassInfo *newClass (bool = false);
  CUnionInfo *newUnion (bool = false);
  CNamespaceInfo *newNamespace ();
  CTemplateInfo *newTemplate ();
  void deleteLocalScope (const CLocalScope *);
  void deleteFunction (const CFunctionInfo *);
  void deleteClass (const CClassInfo *);
  void deleteUnion (const CUnionInfo *);
  void deleteNamespace (const CNamespaceInfo *);
  void deleteTemplate (const CTemplateInfo *);
};


inline CScopeInfo::CScopeInfo (CObjectInfo::ObjectId id) :
  CObjectInfo (id),
  _Children (20, 20),
  _Parent ((CScopeInfo*)this)
 {}
 
inline unsigned CScopeInfo::Children () const
 { return _Children.length (); }
inline CScopeInfo *CScopeInfo::Child (unsigned n) const
 { return _Children.lookup (n); }
inline CScopeInfo *CScopeInfo::Parent () const
 { return _Parent; }

inline bool CScopeInfo::isLocalScope () const
 { return LocalScope (); }
inline bool CScopeInfo::isFile () const 
 { return FileInfo (); }
inline bool CScopeInfo::isNamespace () const 
 { return NamespaceInfo (); }
inline bool CScopeInfo::isRecord () const 
 { return Record (); }
inline bool CScopeInfo::isClass () const 
 { return ClassInfo (); }
inline bool CScopeInfo::isUnion () const 
 { return UnionInfo (); }
inline bool CScopeInfo::isFunction () const 
 { return FunctionInfo (); }
inline bool CScopeInfo::GlobalScope () const 
 { return FileInfo (); }

inline bool CScopeInfo::insideFunction () const 
 { return isFunction () || (Parent () && Parent () != this && 
                            Parent ()->insideFunction ()); }
inline bool CScopeInfo::insideMethod () const 
 { return isMethod () || (Parent () && Parent () != this && 
                          Parent ()->insideMethod ()); }
inline bool CScopeInfo::insideRecord () const 
 { return isRecord () || (Parent () && Parent () != this && 
                          Parent ()->insideRecord ()); }
inline bool CScopeInfo::insideTemplate () const 
 { return isTemplate () || (Parent () && Parent () != this && 
                            Parent ()->insideTemplate ()); }
inline bool CScopeInfo::insideClass () const 
 { return isClass () || (Parent () && Parent () != this && 
                         Parent ()->insideClass ()); }
inline bool CScopeInfo::insideUnion () const 
 { return isUnion () || (Parent () && Parent () != this && 
                         Parent ()->insideUnion ()); }

inline bool CScopeInfo::isLocalClass () const 
 { return isClass () && insideFunction (); }
inline bool CScopeInfo::isLocalUnion () const 
 { return isUnion () && insideFunction (); }
inline bool CScopeInfo::isLocalRecord () const 
 { return isRecord () && insideFunction (); }


} // namespace Puma

#endif /* __CScopeInfo_h__ */

#ifdef __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CScopeInfo_h__
/*** begin of aspect includes ***/
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__
#include "WinIfExists.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__
#include "WinImportHandler.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__
#include "WinMacros.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__
#include "CMatchSyntax.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__
#include "ExtGnu.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__
#include "ExtAC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderH_ah__
#include "ExtACBuilderH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderCC_ah__
#include "ExtACBuilderCC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__
#include "ExtACSyntaxH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxCC_ah__
#include "ExtACSyntaxCC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__
#include "ExtACTree.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
#include "ExtACKeywords.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_TraceSyntax_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_TraceSyntax_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_TraceSyntax_ah__
#include "TraceSyntax.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__
#include "WinAsm.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__
#include "WinDeclSpecs.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__
#include "WinMemberExplSpec.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__
#include "WinTypeKeywords.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__
#include "PragmaOnceUnitState.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__
#include "PragmaOnce.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveH_ah__
#include "CCExprResolveH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveCC_ah__
#include "CCExprResolveCC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveH_ah__
#include "CExprResolveH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveCC_ah__
#include "CExprResolveCC.ah"
#endif
/*** end of aspect includes ***/
#undef __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#undef __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CScopeInfo_h__
#endif // __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_CScopeInfo_h__
