#ifndef __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#define __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#define __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_InstantiationCandidate_h__

#ifndef __ac_h_
#define __ac_h_
namespace AC {
  typedef const char* Type;
  enum JPType { CALL = 0x0004, EXECUTION = 0x0008, CONSTRUCTION = 0x0010, DESTRUCTION = 0x0020 };
  struct Action {
    void **_args; void *_result; void *_target; void *_that; void *_fptr;
    void (*_wrapper)(Action &);
    inline void trigger () { _wrapper (*this); }
  };
  struct AnyResultBuffer {};
  template <typename T> struct ResultBuffer : public AnyResultBuffer {
    char _data[sizeof (T)];
    ~ResultBuffer () { ((T*)_data)->T::~T(); }
    operator T& () const { return *(T*)_data; }
  };
  template <class Aspect, int Index>
  struct CFlow {
    static int &instance () {
      static int counter = 0;
      return counter;
    }
    CFlow () { instance ()++; }
    ~CFlow () { instance ()--; }
    static bool active () { return instance () > 0; }
  };
}
inline void * operator new (__SIZE_TYPE__, AC::AnyResultBuffer *p) { return p; }
inline void operator delete (void *, AC::AnyResultBuffer *) { } // for VC++
#endif // __ac_h_
#endif // __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __InstantiationCandidate__
#define __InstantiationCandidate__

#include "Puma/Array.h"
#include "Puma/ErrorSink.h"
#include "Puma/DeducedArgument.h"

namespace Puma {


class CTree;
class CUnit;
class CTypeInfo;
class CConstant;
class CStructure;
class CT_ExprList;
class CObjectInfo;
class CT_SimpleName;
class CTemplateInfo;
class CTemplateParamInfo;

} // closed Puma
class WinIfExists;
class WinImportHandler;
class WinMacros;
class CMatchSyntax;
class ExtGnu;
class ExtAC;
class ExtACBuilderCoupling;
class ExtACSyntaxCoupling;
class ExtACTree;
class ExtACKeywords;
class WinAsm;
class WinDeclSpecs;
class WinMemberExplSpec;
class WinTypeKeywords;
class PragmaOnceUnitState;
class PragmaOnce;
class CCExprResolve;
class CExprResolve;
namespace Puma {
class InstantiationCandidate {  friend class ::WinIfExists;
  friend class ::WinImportHandler;
  friend class ::WinMacros;
  friend class ::CMatchSyntax;
  friend class ::ExtGnu;
  friend class ::ExtAC;
  friend class ::ExtACBuilderCoupling;
  friend class ::ExtACSyntaxCoupling;
  friend class ::ExtACTree;
  friend class ::ExtACKeywords;
  friend class ::WinAsm;
  friend class ::WinDeclSpecs;
  friend class ::WinMemberExplSpec;
  friend class ::WinTypeKeywords;
  friend class ::PragmaOnceUnitState;
  friend class ::PragmaOnce;
  friend class ::CCExprResolve;
  friend class ::CExprResolve;

  typedef Array<CTree*> ArgumentList;
  typedef Array<DeducedArgument*> DeducedArgumentList;
  
  ArgumentList         arguments;
  DeducedArgumentList  darguments;
  CObjectInfo         *obj_info;
  CTemplateInfo       *tpl_info;
  CTree               *poi;
  ErrorSink           *err;
  
public:
  InstantiationCandidate (); 
  ~InstantiationCandidate ();
  
  void reset ();
  void initialize (ErrorSink *e);
  void initialize (CTree *p, CObjectInfo *o);
  void initialize (CTree *p, CObjectInfo *o, CTemplateInfo *t, ErrorSink *e = 0);
  void addArgument (CTree *);
  void forgetDeducedArgs ();

  bool deduceArguments (bool real_inst);
  bool match ();
  int compare (InstantiationCandidate &);

  CObjectInfo *ObjectInfo () const;
  CTemplateInfo *TemplateInfo () const;
  CTree *PointOfInstantiation () const;

  unsigned Arguments () const;
  unsigned DeducedArgs () const;
  CTree *Argument (unsigned) const;
  DeducedArgument *DeducedArg (unsigned) const;

  int getPosition (CTemplateParamInfo *) const;

private:
  bool deduceArguments (unsigned skip);
  bool deduceArguments (CTypeInfo *, CTypeInfo *, DeducedArgumentList &);
  bool matchArgument (CTree *pexpr, CTree *aexpr);
  bool matchArgument (CTypeInfo *ptype, CTypeInfo *atype, CTree *aexpr);
  bool sameValue (int pos, CConstant *value);
  bool sameType (int pos, CTypeInfo *type);
};

inline CObjectInfo *InstantiationCandidate::ObjectInfo () const
 { return obj_info; }
inline CTemplateInfo *InstantiationCandidate::TemplateInfo () const
 { return tpl_info; }
inline CTree *InstantiationCandidate::PointOfInstantiation () const
 { return poi; }

inline unsigned InstantiationCandidate::Arguments () const 
 { return arguments.length (); }
inline unsigned InstantiationCandidate::DeducedArgs () const
 { return darguments.length (); }
inline CTree *InstantiationCandidate::Argument (unsigned i) const
 { return arguments.lookup (i); }
inline DeducedArgument *InstantiationCandidate::DeducedArg (unsigned i) const
 { return darguments.lookup (i); }

inline void InstantiationCandidate::addArgument (CTree *a)
 { arguments.append (a); }
inline void InstantiationCandidate::forgetDeducedArgs () 
 { darguments.reset (); }


} // namespace Puma

#endif /* __InstantiationCandidate__ */

#ifdef __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_InstantiationCandidate_h__
/*** begin of aspect includes ***/
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinIfExists_ah__
#include "WinIfExists.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinImportHandler_ah__
#include "WinImportHandler.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMacros_ah__
#include "WinMacros.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CMatchSyntax_ah__
#include "CMatchSyntax.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtGnu_ah__
#include "ExtGnu.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtAC_ah__
#include "ExtAC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderH_ah__
#include "ExtACBuilderH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACBuilderCC_ah__
#include "ExtACBuilderCC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxH_ah__
#include "ExtACSyntaxH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACSyntaxCC_ah__
#include "ExtACSyntaxCC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACTree_ah__
#include "ExtACTree.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_ExtACKeywords_ah__
#include "ExtACKeywords.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_TraceSyntax_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_TraceSyntax_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_TraceSyntax_ah__
#include "TraceSyntax.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinAsm_ah__
#include "WinAsm.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinDeclSpecs_ah__
#include "WinDeclSpecs.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinMemberExplSpec_ah__
#include "WinMemberExplSpec.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_WinTypeKeywords_ah__
#include "WinTypeKeywords.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnceUnitState_ah__
#include "PragmaOnceUnitState.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_PragmaOnce_ah__
#include "PragmaOnce.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveH_ah__
#include "CCExprResolveH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CCExprResolveCC_ah__
#include "CCExprResolveCC.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveH_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveH_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveH_ah__
#include "CExprResolveH.ah"
#endif
#if !defined(__ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveCC_ah__) && defined(__ac_need__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveCC_ah__)
#define __ac_have__tmp_AOP_LIN_AOP_Puma_gen45release_step1_aspects_CExprResolveCC_ah__
#include "CExprResolveCC.ah"
#endif
/*** end of aspect includes ***/
#undef __ac_FIRST__tmp_AOP_LIN_AOP_Puma_gen45release_step1__
#undef __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_InstantiationCandidate_h__
#endif // __ac_FIRST_FILE__tmp_AOP_LIN_AOP_Puma_gen45release_step1_inc_Puma_InstantiationCandidate_h__
