// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#include "Puma/CCommentRecognizer.h"
#include "Puma/ScanBuffer.h"

// Token definitions for comment tokens
#include "Puma/CCommentTokens.h"

namespace Puma {


// Include generated scanner tables
#include "CCommentTab.ot"
#include "CSLCommentTab.ot"
#include "CMLCommentTab.ot"
void * volatile dummy = CMLCommentTabLookAheadTab; // only to avoid warning!

// Instantiate generated recognizers

MappedOrangeRecognizer<CScanBuffer> CCommentRecognizer::comment_recognizer (CCommentTabMap, 
  CCommentTabExprMap, CCommentTabStart, CCommentTabStates, CCommentTabNext, 
  CCommentTabControl, sizeof (CCommentTabNext) / sizeof (int));

MappedOrangeRecognizer<CScanBuffer> CCommentRecognizer::sl_comment_recognizer (
  CSLCommentTabMap, CSLCommentTabExprMap,
  CSLCommentTabStart, CSLCommentTabStates, CSLCommentTabNext, 
  CSLCommentTabControl, sizeof (CSLCommentTabNext) / sizeof (int));
   
MappedOrangeRecognizer<CScanBuffer> CCommentRecognizer::ml_comment_recognizer (
  CMLCommentTabMap, CMLCommentTabExprMap,
  CMLCommentTabStart, CMLCommentTabStates,  CMLCommentTabNext, 
  CMLCommentTabControl, sizeof (CMLCommentTabNext) / sizeof (int));
   

int CCommentRecognizer::recognize (CScanBuffer *scan_buffer, int &expr, int &len) {
  int result;

  if (comment_mode == ML_COMMENT) {
    bool done = false;
    while (! done) {
      if ((result = ml_comment_recognizer.recognize (scan_buffer, expr, len)) > 0) {
        switch (expr) {
          case TOK_CCMULTIEND:
            comment_mode = NO_COMMENT; // no break!
          case TOK_CCOMMENT:
            done = true;
            break;
          default:
            scan_buffer->more (len);
        }
      } else {
        result = -1;
      }
    }
  } else if (comment_mode == SL_COMMENT) {
    result = sl_comment_recognizer.recognize (scan_buffer, expr, len);
    comment_mode = NO_COMMENT;
  } else {
    if ((result = comment_recognizer.recognize (scan_buffer, expr, len)) > 0)
      comment_mode = (expr == TOK_CCSINGLE) ? SL_COMMENT : ML_COMMENT;
  }
  return result;
}


} // namespace Puma
