ifeq ($(MAKELEVEL),0)
$(error Sorry, this makefile is not intended to be \
used directly. Please use the makefile in the toplevel \
directory of the PUMA source tree instead)
endif

#-------------------------------------------------
# variables 
#-------------------------------------------------

LEMOBJECTS := $(addprefix $(STEP1)/src/, \
	$(patsubst %.lem,%.cc, $(notdir $(LEMSOURCES))))
ORAOBJECTS := $(addprefix $(STEP1)/src/, \
	$(patsubst %.ora,%.ot, $(notdir $(ORASOURCES))))
SRCTOCOPY  := $(SOURCES) 

FINDINCS    = $(wildcard $(dir)*.h)
SRCDIRS     = $(sort $(dir $(SOURCES)))
INCTOCOPY   = $(foreach dir,$(SRCDIRS),$(FINDINCS)) $(LEMOBJECTS:.cc=.h)

#-------------------------------------------------
# rules
#-------------------------------------------------

vpath %.lem $(dir $(LEMSOURCES))
vpath %.ora $(dir $(ORASOURCES))

all: $(ORAOBJECTS) $(LEMOBJECTS)
	@cp -p $(INCTOCOPY) $(STEP1)/inc/Puma/
	@cp -p $(SRCTOCOPY) $(STEP1)/src
	@cp -p $(ASPECTS)   $(STEP1)/aspects

#-------------------------------------------------
# targets
#-------------------------------------------------

$(STEP1)/src/%.cc : %.lem
	@echo "Calling Lemon on $<..."
	@$(ROOT)/tools/lemon/lemon -q $< $(STEP1)/src/; true

$(STEP1)/src/%.ot : %.ora
	@echo "Calling Orange on $<..."
	@$(ROOT)/tools/orange/orange $< >>  $@


.PHONY: all
