// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CFctInstance_h__
#define __CFctInstance_h__

// function template instance info

#include "Puma/CTemplateInstance.h"
#include "Puma/CFunctionInfo.h"

namespace Puma {


/** \file 
 *  Representation of an instance of a function template.
 *  \see Puma::CFctInstance */

/** \class CFctInstance CFctInstance.h Puma/infos/CFctInstance.h
 *  A CFctInstance object represents an instance of a function template. */
class CFctInstance : public CFunctionInfo {
  CTemplateInstance _InstanceInfo;

public: 
  /** Construct a new function template instance object. */
  CFctInstance ();
  /** Destruct the function template instance object. If the object id is 
   *  \c FCT_INSTANCE_INFO, Puma::CObjectInfo::CleanUp() is called. */
  ~CFctInstance ();

  /** Get the corresponding template instance info. */
  CTemplateInstance *TemplateInstance () const;
};

inline CFctInstance::CFctInstance () :
  CFunctionInfo (CObjectInfo::FCT_INSTANCE_INFO)
 {}
inline CFctInstance::~CFctInstance ()
 { if (Id () == FCT_INSTANCE_INFO) CleanUp (); }

inline CTemplateInstance *CFctInstance::TemplateInstance () const
 { return (CTemplateInstance*)(&_InstanceInfo); }


} // namespace Puma

#endif /* __CFctInstance_h__ */
