// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypeArray_h__
#define __CTypeArray_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


class CTypeArray : public CTypeInfo {
  long int _Size;
  bool _isFixed;
  CTypeQualified *_Quals;
  CTypeTemplateParam *_DepDim;

protected:
  CTypeArray (CTypeInfo *, CTypeQualified *, TypeId);
  
public:
  CTypeArray (CTypeInfo *, CTypeQualified * = 0);
  ~CTypeArray ();

  void Dimension (long int);
  long int Dimension () const;
  
  void isFixed (bool);
  bool isFixed () const;
  
  CTypeQualified *Qualifiers () const;
  
  void DepDim (CTypeTemplateParam *);
  CTypeTemplateParam *DepDim () const;
};

inline CTypeArray::CTypeArray (CTypeInfo *base, CTypeQualified *quals) :
  CTypeInfo (base, CTypeInfo::TYPE_ARRAY),
  _Size (0),
  _isFixed (false),
  _Quals (quals),
  _DepDim (0)
 {}
inline CTypeArray::CTypeArray (CTypeInfo *base, CTypeQualified *quals, CTypeInfo::TypeId id) :
  CTypeInfo (base, id),
  _Size (0),
  _isFixed (false),
  _Quals (quals),
  _DepDim (0)
 {}
inline CTypeArray::~CTypeArray ()
 { if (_Quals) CTypeInfo::Destroy (_Quals); }

inline void CTypeArray::Dimension (long int d)
 { _Size = d; }
inline long int CTypeArray::Dimension () const
 { return _Size; }

inline void CTypeArray::isFixed (bool v)
 { _isFixed = v; }
inline bool CTypeArray::isFixed () const
 { return _isFixed; }

inline CTypeQualified *CTypeArray::Qualifiers () const
 { return _Quals; }
 
inline void CTypeArray::DepDim (CTypeTemplateParam *tp) 
 { _DepDim = tp; }
inline CTypeTemplateParam *CTypeArray::DepDim () const
 { return _DepDim; }


} // namespace Puma

#endif /* __CTypeArray_h__ */
