// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CTypePrimitive_h__
#define __CTypePrimitive_h__

#ifndef __CTypeInfo_h__
#warning !!!      DO NOT INCLUDE THIS FILE      !!!  
#warning !!! INCLUDE FILE "CTypeInfo.h" INSTEAD !!!  
#endif

namespace Puma {


class CTypePrimitive : public CTypeInfo {
  const char *_Text;

public:
  CTypePrimitive (const char *, TypeId);
  ~CTypePrimitive ();
  
  const char *TypeName () const;
};

inline CTypePrimitive::CTypePrimitive (const char *t, CTypeInfo::TypeId id) :
  CTypeInfo (&CTYPE_EMPTY, id),
  _Text (t)
 {}
inline CTypePrimitive::~CTypePrimitive () 
 {}
 
inline const char *CTypePrimitive::TypeName () const
 { return _Text; }

// Basic types //////////////////////////////////////////////////

extern CTypePrimitive CTYPE_BOOL;
extern CTypePrimitive CTYPE_CHAR;
extern CTypePrimitive CTYPE_SIGNED_CHAR;
extern CTypePrimitive CTYPE_UNSIGNED_CHAR;
extern CTypePrimitive CTYPE_WCHAR_T;
extern CTypePrimitive CTYPE_SHORT;
extern CTypePrimitive CTYPE_UNSIGNED_SHORT;
extern CTypePrimitive CTYPE_INT;
extern CTypePrimitive CTYPE_UNSIGNED_INT;
extern CTypePrimitive CTYPE_LONG;
extern CTypePrimitive CTYPE_UNSIGNED_LONG;
extern CTypePrimitive CTYPE_LONG_LONG;
extern CTypePrimitive CTYPE_UNSIGNED_LONG_LONG;
extern CTypePrimitive CTYPE_FLOAT;
extern CTypePrimitive CTYPE_DOUBLE;
extern CTypePrimitive CTYPE_LONG_DOUBLE;
extern CTypePrimitive CTYPE_VOID;
extern CTypePrimitive CTYPE_UNKNOWN_T;
extern CTypePrimitive CTYPE_UNDEFINED;
extern CTypePrimitive CTYPE_ELLIPSIS;


} // namespace Puma

#endif /* __CTypePrimitive_h__ */
