// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __CCSyntax_h__
#define __CCSyntax_h__

// Parser for the C++ programming language

#include "Puma/CSyntax.h"

namespace Puma {


class CCSemantic;
class CCBuilder;
class CStructure;

class CCSyntax : public CSyntax {
  friend class CCSemantic;
  int _skip_bodies;
  
  enum {
    SKIP_BODIES_NONE               = 0x0,  // don't skip function bodies
    SKIP_BODIES_ALL                = 0x1,  // skip all function bodies
    SKIP_BODIES_TPL                = 0x2,  // skip function bodies of templates
    SKIP_BODIES_NON_PRJ            = 0x4   // skip bodies of non-project functions
  };

public:
  CCSyntax (CCBuilder &, CCSemantic &);
  
  virtual void configure (Config &);
  
  void config_skip_fct_body (bool s) { 
    if (s) _skip_bodies |= SKIP_BODIES_ALL; 
    else   _skip_bodies ^= (_skip_bodies & SKIP_BODIES_ALL); 
  }

protected:
  CCBuilder &builder () const;
  CCSemantic &semantic () const;

protected:
  // FIRST sets
  tokenset _explicit_instantiation_1;
  tokenset _explicit_specialization_1;
  tokenset _enum_name_1;
  tokenset _namespace_name_1;
  tokenset _original_ns_name_1;
  tokenset _namespace_alias_1;
  tokenset _qual_id_1;
  tokenset _unqual_id_1;
  tokenset _access_spec_1;
  tokenset _conv_fct_id_1;
  tokenset _oper_fct_id_1;
  tokenset _template_key_1;
  tokenset _template_id_1;
  tokenset _class_name_1;
  tokenset _namespace_def_1;
  tokenset _named_ns_def_1;
  tokenset _original_ns_def_1;
  tokenset _extension_ns_def_1;
  tokenset _unnamed_ns_def_1;
  tokenset _colon_colon_1;
  tokenset _nested_name_spec_1;
  tokenset _nested_name_spec1_1;
  tokenset _class_or_ns_name_1;
  
  virtual void init_explicit_instantiation ();
  virtual void init_explicit_specialization ();
  virtual void init_prim_types ();
  virtual void init_enum_name ();
  virtual void init_namespace_name ();
  virtual void init_original_ns_name ();
  virtual void init_namespace_alias ();
  virtual void init_prim_expr ();
  virtual void init_id_expr ();
  virtual void init_qual_id ();
  virtual void init_unqual_id ();
  virtual void init_access_spec ();
  virtual void init_conv_fct_id ();
  virtual void init_oper_fct_id ();
  virtual void init_template_key ();
  virtual void init_template_id ();
  virtual void init_class_template_id ();
  virtual void init_class_name ();
  virtual void init_type_name ();
  virtual void init_class_key ();
  virtual void init_cv_qual ();
  virtual void init_elaborated_type_spec ();
  virtual void init_simple_type_spec ();
  virtual void init_misc_spec ();
  virtual void init_storage_class_spec ();
  virtual void init_fct_spec ();
  virtual void init_namespace_def ();
  virtual void init_named_ns_def ();
  virtual void init_original_ns_def ();
  virtual void init_extension_ns_def ();
  virtual void init_unnamed_ns_def ();
  virtual void init_colon_colon ();
  virtual void init_nested_name_spec ();
  virtual void init_nested_name_spec1 ();
  virtual void init_class_or_ns_name ();
  virtual void init_postfix_expr1 ();
  virtual void init_direct_declarator1 ();
  
  
  // Grammar rules
public:

  // A.1 Keywords
  CTree * rule_class_name ();
  virtual bool class_name ();
  CTree * rule_enum_name ();
  virtual bool enum_name ();
  virtual CTree *template_name ();
  virtual CTree *class_template_name ();
  CTree * rule_namespace_name ();
  virtual bool namespace_name ();
  CTree * rule_original_ns_name ();
  virtual bool original_ns_name ();
  CTree * rule_namespace_alias ();
  virtual bool namespace_alias ();
  
  // A.4 Expression
  CTree * rule_prim_expr ();
  virtual bool prim_expr ();
  CTree * rule_id_expr ();
  virtual bool id_expr ();
  CTree * rule_qual_id ();
  virtual bool qual_id ();
  CTree * rule_unqual_id ();
  virtual bool unqual_id ();
  CTree * rule_colon_colon ();
  virtual bool colon_colon ();
  CTree * rule_nested_name_spec ();
  virtual bool nested_name_spec ();
  CTree * rule_nested_name_spec1 ();
  virtual bool nested_name_spec1 ();
  CTree * rule_class_or_ns_name ();
  virtual bool class_or_ns_name ();
  virtual CTree *postfix_expr ();
  CTree * rule_postfix_expr1 ();
  virtual bool postfix_expr1 ();
  virtual CTree *postfix_expr2 ();
  virtual CTree *pseudo_dtor_name ();
  virtual CTree *unary_expr ();
  virtual CTree *new_expr ();
  virtual CTree *new_placement ();
  virtual CTree *new_type_id ();
  virtual CTree *new_declarator ();
  virtual CTree *direct_new_declarator ();
  virtual CTree *direct_new_declarator1 ();
  virtual CTree *new_init ();
  virtual CTree *delete_expr ();
  virtual CTree *pm_expr ();
  virtual CTree *mul_expr ();
  virtual CTree *rel_expr ();
  virtual CTree *cond_expr ();
  virtual CTree *ass_expr ();
  virtual CTree *ass_expr1 ();
  virtual CTree *const_expr ();

  // A.5 Statements
  virtual CTree *stmt ();
  virtual CTree *stmt_seq ();
  virtual CTree *sub_stmt ();
  virtual CTree *condition ();
  virtual CTree *condition1 ();
  virtual CTree *decl_stmt ();
      
  // A.6 Declarations
  virtual CTree *decl ();
  virtual CTree *block_decl ();
  virtual CTree *simple_decl ();
  CTree *rule_simple_type_spec ();
  virtual bool simple_type_spec ();
  CTree *rule_type_name ();
  virtual bool type_name ();
  CTree *rule_elaborated_type_spec ();
  virtual bool elaborated_type_spec ();
  virtual CTree *enumerator_list ();
  virtual CTree *enumerator_def ();
  virtual CTree *asm_def ();
  virtual CTree *linkage_spec ();

  // A.6.1 Namespaces
  CTree *rule_namespace_def ();
  virtual bool namespace_def ();
  CTree *rule_named_ns_def ();
  virtual bool named_ns_def ();
  CTree *rule_original_ns_def ();
  virtual bool original_ns_def ();
  CTree *rule_extension_ns_def ();
  virtual bool extension_ns_def ();
  CTree *rule_unnamed_ns_def ();
  virtual bool unnamed_ns_def ();
  virtual CTree *namespace_body ();
  virtual CTree *ns_alias_def ();
  virtual CTree *qual_ns_spec ();
  virtual CTree *using_decl ();
  virtual CTree *using_directive ();

  // A.7 Declarators
  virtual CTree *init_declarator ();
  CTree * rule_direct_declarator1 ();
  virtual bool direct_declarator1 ();
  virtual CTree *array_delim ();
  virtual CTree *ptr_operator ();
  virtual CTree *declarator_id ();
  virtual CTree *direct_abst_declarator ();
  virtual CTree *param_decl_clause ();
  virtual CTree *param_decl ();
  virtual CTree *param_init ();
  virtual CTree *fct_def ();
  virtual CTree *skipped_fct_body ();
  virtual CTree *fct_body ();
  virtual CTree *init ();
  virtual CTree *init_clause ();

  // A.8 Classes
  CTree *rule_class_spec ();
  virtual bool class_spec ();
  CTree *rule_class_head ();
  virtual bool class_head ();
  virtual CTree *member_decl ();
  virtual CTree *member_decl1 ();
  virtual CTree *access_decl ();
  virtual CTree *member_declarator ();
  virtual CTree *pure_spec ();
  virtual CTree *const_init ();

  // A.9 Derived classes
  virtual CTree *base_clause ();
  virtual CTree *base_spec_list ();
  virtual CTree *base_spec ();
  CTree * rule_access_spec ();
  virtual bool access_spec ();

  // A.10 Special member functions
  CTree *rule_conv_fct_id ();
  virtual bool conv_fct_id ();
  virtual CTree *conv_type_id ();
  virtual CTree *conv_declarator ();
  virtual CTree *ctor_init ();
  virtual CTree *mem_init_list ();
  virtual CTree *mem_init ();
  virtual CTree *mem_init_id ();

  // A.11 Overloading
  CTree *rule_oper_fct_id ();
  virtual bool oper_fct_id ();

  // A.12 Templates
  CTree * rule_template_key (); 
  virtual bool template_key (); 
  virtual CTree *template_decl (); 
  virtual CTree *member_template_decl (); 
  virtual CTree *template_param_list (); 
  virtual CTree *template_param (); 
  virtual CTree *type_param (); 
  virtual CTree *non_type_param (); 
  CTree *rule_template_id (); 
  virtual bool template_id ();
  CTree *rule_class_template_id (); 
  virtual bool class_template_id ();
  virtual CTree *template_arg_list (); 
  virtual CTree *template_arg (); 
  CTree * rule_explicit_instantiation (); 
  virtual bool explicit_instantiation (); 
  CTree * rule_explicit_specialization (); 
  virtual bool explicit_specialization (); 

  // A.13 Exception handling
  virtual CTree *try_block ();
  virtual CTree *fct_try_block ();
  virtual CTree *handler_seq ();
  virtual CTree *handler ();
  virtual CTree *exception_decl ();
  virtual CTree *throw_expr ();
  virtual CTree *exception_spec ();
  virtual CTree *type_id_list (); 

protected:
  void skip_param_init ();
  void skip_ctor_init ();
  void skip_fct_body ();
  void skip_fct_try_block ();
  void skip_const_expr ();
  void skip_const_init ();
  
protected:
  bool is_nested (State);
  bool is_nested_name ();
  bool is_class_def ();

protected:
  struct SearchScope { CStructure *scope, *last_scope; bool dep; };
  void get_search_scope (SearchScope &);
  void set_search_scope (SearchScope &);
};


} // namespace Puma

#endif /* __CCSyntax_h__ */
