
namespace afilter {

  template <typename T = char2uni>
  class UTF8_unichar : public char_repl_types<T>
  {
  public:
    utf8_unichar * clone() const {return new utf8_unichar(*this);}

    string name() const {return "utf8/unichar";}
    double order_num() const {return 0.09;}
    int max_in()  const {return 4;}
    int max_out() const {return 1;}

    bool fill(char, Itr *, Buffer *);
  };

  template <typename T = uni2char>
  class unichar_utf8 : public char_repl_types<T>
  {
  public:
    unichar_utf8 * clone() const {return new unichar_utf8(*this);}

    string name() const {return "unichar/utf8";}
    double order_num() const {return 0.11;}
    int max_in()  const {return 1;}
    int max_out() const {return 4;}

    void fill(unichar, Itr *, Buffer *);
  };
}
