// Copyright 2000 by Kevin Atkinson under the terms of the LGPL

#include <ctime>

#include "writable_base.hh"
#include "file_util.hh"
#include "data_util.hh"
#include "file_exceps.hh"

namespace aspell {
  
  namespace writable_base {

    using namespace aspell::data_util; 

    void WritableBaseCode::update_file_date_info(SimpleFstream & f) {
      update_file_info(f);
      cur_file_date = get_modification_time(f);
    }

    void WritableBaseCode::load(const string & f0, 
				Config * config)
    {
      set_file_name(f0);
      const string f = file_name();
      SimpleFstream in;
    
      if (file_exists(f)) {
      
	open_file_readlock(in, f);
	merge(in, f, config);
      
      } else if (f.substr(f.size()-suffix.size(),suffix.size()) 
		 == suffix) {
      
	compatibility_file_name = f.substr(0,f.size() - suffix.size());
	compatibility_file_name += compatibility_suffix;
      
	try {
	  open_file_readlock(in, compatibility_file_name);
	  merge(in, compatibility_file_name, config);
	} catch (...) {
	  compatibility_file_name = "";
	  throw;
	}
      
      } else {
      
	throw CantReadFile(f);
      
      }

      update_file_date_info(in);
    }

    void WritableBaseCode::merge(const string & f0) {
      SimpleFstream in;
      DataSet::FileName fn(f0);
      open_file_readlock(in, fn.path);
      merge(in, fn.path);
    }

    void WritableBaseCode::update(SimpleFstream & in, const string & fn) {
      try {
	
	merge(in, fn);
	update_file_date_info(in);
      
      } catch (CantReadFile &) {
      
	if (compatibility_file_name.empty())
	  throw;
      }
    }
    
    void WritableBaseCode::save2(SimpleFstream & out, const string & fn) {
      truncate_file(out, fn);
      
      save(out,fn);

      out.flush();
    }

    void WritableBaseCode::save_as(const string & fn) {
      compatibility_file_name = "";
      set_file_name(fn);
      SimpleFstream inout;
      open_file_writelock(inout, file_name());
      save2(inout, file_name());
      update_file_date_info(inout);
    }

    void WritableBaseCode::save(bool do_update) {
      SimpleFstream inout;
      bool prev_existed = open_file_writelock(inout, file_name());

      if (do_update
	  && prev_existed 
	  && get_modification_time(inout) > cur_file_date)
	update(inout, file_name());

      save2(inout, file_name());
      update_file_date_info(inout);
    
      if (compatibility_file_name.size() != 0) {
	remove_file(compatibility_file_name.c_str());
	compatibility_file_name = "";
      }
    
    }
  
  }
}
