/*
** In this include-file specific structs are defined which are filled
** by sscanf-ing the ascii-values produced by reading several /proc-files.
*/

/*
** Obtained from /usr/src/linux/include/net/snmp.h
*/
struct ip_mib {
 	unsigned long	IpForwarding;
 	unsigned long	IpDefaultTTL;
 	unsigned long	IpInReceives;
 	unsigned long	IpInHdrErrors;
 	unsigned long	IpInAddrErrors;
 	unsigned long	IpForwDatagrams;
 	unsigned long	IpInUnknownProtos;
 	unsigned long	IpInDiscards;
 	unsigned long	IpInDelivers;
 	unsigned long	IpOutRequests;
 	unsigned long	IpOutDiscards;
 	unsigned long	IpOutNoRoutes;
 	unsigned long	IpReasmTimeout;
 	unsigned long	IpReasmReqds;
 	unsigned long	IpReasmOKs;
 	unsigned long	IpReasmFails;
 	unsigned long	IpFragOKs;
 	unsigned long	IpFragFails;
 	unsigned long	IpFragCreates;
};
 
struct ipv6_mib {
	unsigned long	Ip6InReceives;
 	unsigned long	Ip6InHdrErrors;
 	unsigned long	Ip6InTooBigErrors;
 	unsigned long	Ip6InNoRoutes;
 	unsigned long	Ip6InAddrErrors;
 	unsigned long	Ip6InUnknownProtos;
 	unsigned long	Ip6InTruncatedPkts;
 	unsigned long	Ip6InDiscards;
 	unsigned long	Ip6InDelivers;
 	unsigned long	Ip6OutForwDatagrams;
 	unsigned long	Ip6OutRequests;
 	unsigned long	Ip6OutDiscards;
 	unsigned long	Ip6OutNoRoutes;
 	unsigned long	Ip6ReasmTimeout;
 	unsigned long	Ip6ReasmReqds;
 	unsigned long	Ip6ReasmOKs;
 	unsigned long	Ip6ReasmFails;
 	unsigned long	Ip6FragOKs;
 	unsigned long	Ip6FragFails;
 	unsigned long	Ip6FragCreates;
 	unsigned long	Ip6InMcastPkts;
 	unsigned long	Ip6OutMcastPkts;
};
 
struct icmp_mib {
 	unsigned long	IcmpInMsgs;
 	unsigned long	IcmpInErrors;
  	unsigned long	IcmpInDestUnreachs;
 	unsigned long	IcmpInTimeExcds;
 	unsigned long	IcmpInParmProbs;
 	unsigned long	IcmpInSrcQuenchs;
 	unsigned long	IcmpInRedirects;
 	unsigned long	IcmpInEchos;
 	unsigned long	IcmpInEchoReps;
 	unsigned long	IcmpInTimestamps;
 	unsigned long	IcmpInTimestampReps;
 	unsigned long	IcmpInAddrMasks;
 	unsigned long	IcmpInAddrMaskReps;
 	unsigned long	IcmpOutMsgs;
 	unsigned long	IcmpOutErrors;
 	unsigned long	IcmpOutDestUnreachs;
 	unsigned long	IcmpOutTimeExcds;
 	unsigned long	IcmpOutParmProbs;
 	unsigned long	IcmpOutSrcQuenchs;
 	unsigned long	IcmpOutRedirects;
 	unsigned long	IcmpOutEchos;
 	unsigned long	IcmpOutEchoReps;
 	unsigned long	IcmpOutTimestamps;
 	unsigned long	IcmpOutTimestampReps;
 	unsigned long	IcmpOutAddrMasks;
 	unsigned long	IcmpOutAddrMaskReps;
};

struct icmpv6_mib {
	unsigned long	Icmp6InMsgs;
	unsigned long	Icmp6InErrors;

	unsigned long	Icmp6InDestUnreachs;
	unsigned long	Icmp6InPktTooBigs;
	unsigned long	Icmp6InTimeExcds;
	unsigned long	Icmp6InParmProblems;

	unsigned long	Icmp6InEchos;
	unsigned long	Icmp6InEchoReplies;
	unsigned long	Icmp6InGroupMembQueries;
	unsigned long	Icmp6InGroupMembResponses;
	unsigned long	Icmp6InGroupMembReductions;
	unsigned long	Icmp6InRouterSolicits;
	unsigned long	Icmp6InRouterAdvertisements;
	unsigned long	Icmp6InNeighborSolicits;
	unsigned long	Icmp6InNeighborAdvertisements;
	unsigned long	Icmp6InRedirects;

	unsigned long	Icmp6OutMsgs;

	unsigned long	Icmp6OutDestUnreachs;
	unsigned long	Icmp6OutPktTooBigs;
	unsigned long	Icmp6OutTimeExcds;
	unsigned long	Icmp6OutParmProblems;

	unsigned long	Icmp6OutEchoReplies;
	unsigned long	Icmp6OutRouterSolicits;
	unsigned long	Icmp6OutNeighborSolicits;
	unsigned long	Icmp6OutNeighborAdvertisements;
	unsigned long	Icmp6OutRedirects;
	unsigned long	Icmp6OutGroupMembResponses;
	unsigned long	Icmp6OutGroupMembReductions;
};
 
struct tcp_mib {
 	unsigned long	TcpRtoAlgorithm;
 	unsigned long	TcpRtoMin;
 	unsigned long	TcpRtoMax;
 	unsigned long	TcpMaxConn;
 	unsigned long	TcpActiveOpens;
 	unsigned long	TcpPassiveOpens;
 	unsigned long	TcpAttemptFails;
 	unsigned long	TcpEstabResets;
 	unsigned long	TcpCurrEstab;
 	unsigned long	TcpInSegs;
 	unsigned long	TcpOutSegs;
 	unsigned long	TcpRetransSegs;
 	unsigned long	TcpInErrs;
 	unsigned long	TcpOutRsts;
};
 
struct udp_mib {
 	unsigned long	UdpInDatagrams;
 	unsigned long	UdpNoPorts;
 	unsigned long	UdpInErrors;
 	unsigned long	UdpOutDatagrams;
};

struct linux_mib {
	unsigned long	SyncookiesSent;
	unsigned long	SyncookiesRecv;
	unsigned long	SyncookiesFailed;
	unsigned long	EmbryonicRsts;
	unsigned long	PruneCalled; 
	unsigned long	RcvPruned;
	unsigned long	OfoPruned;
	unsigned long	OutOfWindowIcmps; 
	unsigned long	LockDroppedIcmps; 
};

/*
** Kernel-version info
*/
struct osrel {
        short   rel;
        short   vers;
        short   sub;
};


/*
** integer values taken from the output of the file
**            /proc/net/snmp and /proc/net/snmp6
*/
struct netstat {
	struct ip_mib		ip;
	struct icmp_mib		icmp;
	struct tcp_mib		tcp;
	struct udp_mib		udp;

	struct ipv6_mib		ip6;
	struct icmpv6_mib	icmp6;
	struct udp_mib		udp6;
};


/*
** proprietary struct for NFS-counters
*/
struct nfsstat {
	unsigned long	cl_netcnt;
	unsigned long	cl_netudpcnt;
	unsigned long	cl_nettcpcnt;
	unsigned long	cl_nettcpconn;
	unsigned long	cl_rpccnt;
	unsigned long	cl_rpcretrans;
	unsigned long	cl_rpcauthrefresh;
	unsigned long	cl_proc2[20];
	unsigned long	cl_proc3[20];

	unsigned long	sv_netcnt;
	unsigned long	sv_netudpcnt;
	unsigned long	sv_nettcpcnt;
	unsigned long	sv_nettcpconn;
	unsigned long	sv_rpccnt;
	unsigned long	sv_rpcbadtot;
	unsigned long	sv_rpcbadfmt;
	unsigned long	sv_rpcbadauth;
	unsigned long	sv_rpcbadclnt;
	unsigned long	sv_proc2[20];
	unsigned long	sv_proc3[20];
	unsigned long	sv_rchits;
	unsigned long	sv_rcmisses;
	unsigned long	sv_rcnocache;
	unsigned long	sv_fhstale;
	unsigned long	sv_fhlookup;
	unsigned long	sv_fhanon;
	unsigned long	sv_fhnocachedir;
	unsigned long	sv_fhnocachenondir;
	unsigned long	sv_ioread;
	unsigned long	sv_iowrite;
	unsigned long	sv_thcount;
	unsigned long	sv_thlastcnt;
	unsigned long	sv_rasize;
};

/*
** proprietary struct for ftp- and http-counters
*/
#define	MAXLOGNAME	32

struct ftpstat {
	double		ocumxfer;
	double		ocumseconds;
	double		ocumkbytes;
	double		icumxfer;
	double		icumseconds;
	double		icumkbytes;
	char 		logname[MAXLOGNAME];
};

struct httpstat {
	double		cumhead;
	double		cumgets;
	double		cumputs;
	double		cumpost;
	double		cumdels;
	char 		logname[MAXLOGNAME];
};

/*
** integer values taken from the output of the /proc/net/dev file
*/
#define	MAXIFNAME	16

struct ifstat {
	char 		name[MAXIFNAME];
	unsigned long	rbyte;
	unsigned long	rpack;
	unsigned long	rerrs;
	unsigned long	rdrop;
	unsigned long	rfifo;
	unsigned long	rframe;
	unsigned long	rcompr;
	unsigned long	rmultic;
	unsigned long	sbyte;
	unsigned long	spack;
	unsigned long	serrs;
	unsigned long	sdrop;
	unsigned long	sfifo;
	unsigned long	scollis;
	unsigned long	scarrier;
	unsigned long	scompr;
};


/*
** kernel-table occupation
*/
struct tabstat {
	unsigned long	totforks;

	unsigned long	curlocks;
	unsigned long	maxlocks;

	unsigned long	maxdquot;
	unsigned long	curdquot;

	unsigned long	maxfiles;
	unsigned long	curfiles;

	unsigned long	maxinode;
	unsigned long	curinode;

	unsigned long	maxsuper;
	unsigned long	cursuper;
};

/*
** integer values taken from the output of the /proc/meminfo file;
** only memory- and swap-counter lines (line 2 & 3)
*/
struct memstat {
	unsigned long	memory[6];
	unsigned long	swap[3];
};


#define	MTOTAL	0	/* indices for memory[] and swap[] */
#define	MUSED	1
#define	MFREE	2
#define	MSHARED	3
#define	MBUFS	4
#define	MCACHED	5

/*
** Per-partition statistics
*/
struct dkstat {
	unsigned short	major;
	unsigned short	minor;
	char 			name[16];

	unsigned long	totsize;
	unsigned long	readblocks;
	unsigned long	readmerges;
	unsigned long	readsectors;
	unsigned long	read_msecs;

	unsigned long	writblocks;
	unsigned long	writmerges;
	unsigned long	writsectors;
	unsigned long	writ_msecs;

	unsigned long	reqpending;
	unsigned long	rdwr_msecs;
	unsigned long	avq;
};


/*
** Serial interface statistics
*/
struct serialstat {
	unsigned long	port;
	unsigned long	tx;	/* transmits 		*/
	unsigned long	rx;	/* receives 		*/
	unsigned short	fe;	/* frame errors		*/
	unsigned short	pe;	/* parity errors	*/
	unsigned short	br;	/* breaks 		 	*/
	unsigned short	oe;	/* overrun errors	*/
};


/*
** Private structure to store all general system-related counters
** in a uniform version-independent way
*/
#define MAXCPU	32
#define	MAXIRQ	64
#define MAXDISK	64

struct genstat {
	/* CPU-related stuff */
	unsigned long 	cpu_user;
	unsigned long	cpu_nice;
	unsigned long	cpu_system;
	unsigned long	cpu_idle;

	unsigned long	per_cpu_user[MAXCPU];
	unsigned long	per_cpu_nice[MAXCPU];
	unsigned long	per_cpu_system[MAXCPU];
	unsigned long	per_cpu_idle[MAXCPU];

	unsigned long	irqs[MAXIRQ];
	unsigned long	per_irqs[MAXCPU][MAXIRQ];
	unsigned long	context_swtch;

	float		loadavg1;
	float		loadavg5;
	float		loadavg15;
	unsigned long	nrrun;
	unsigned long	nrproc;

	/* disk-related stuff */
	unsigned short	dk_drive_maj[MAXDISK+1];
	unsigned short	dk_drive_min[MAXDISK+1];
	unsigned long	dk_drive_tot[MAXDISK+1];
	unsigned long	dk_drive_rio[MAXDISK+1];
	unsigned long	dk_drive_wio[MAXDISK+1];
	unsigned long	dk_drive_rblk[MAXDISK+1];
	unsigned long	dk_drive_wblk[MAXDISK+1];

	/* memory-related stuff */
	unsigned long	pgpgin;
	unsigned long	pgpgout;
	unsigned long	pswpin;
	unsigned long	pswpout;
};

/*
** Structure to store socket-usage figures
*/
struct sockstat {
	unsigned long   tcpnow;
	unsigned long   tcpmax;
	unsigned long   udpnow;
	unsigned long   udpmax;

	unsigned long   tcp6now;
	unsigned long   tcp6max;
	unsigned long   udp6now;
	unsigned long   udp6max;
};
