/****************************************************************
**
** Attal : Lords of Doom
**
** buildingAction.cpp
** Widget for editing actions of building
**
** Version : $Id: buildingAction.cpp,v 1.2 2004/04/30 21:27:44 lusum Exp $
**
** Author(s) : Sardi Carlo -Pascal Audoux
**
** Date : 29/04/2004
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "buildingAction.h"

// generic include files
// include files for QT
#include <qcombobox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qspinbox.h>
// application specific include files
#include "libCommon/genericBuilding.h"
#include "libCommon/genericLord.h"
#include "libCommon/log.h"
#include "libCommon/action.h"
#include "libCommon/dataTheme.h"

#include "libClient/gui.h"


extern DataTheme DataTheme;

//
// ----- buildingAction -----
//

BuildingAction::BuildingAction( QWidget * parent, const char * name )
: QWidget( parent, name )
{
	_building = 0;
	_listBox = new QListBox( this );

	_pbAdd = new QPushButton( this );
	_pbAdd->setText( tr( "Add" ) );
	FIXEDSIZE( _pbAdd );

	_pbEdit = new QPushButton( this );
	_pbEdit->setText( tr("Edit")  );
	FIXEDSIZE( _pbEdit );

	_pbDel = new QPushButton( this );
	_pbDel->setText( tr( "Del" ) );
	FIXEDSIZE( _pbDel );

	QGridLayout * layout = new QGridLayout( this, 4, 2 );
	layout->setRowStretch( 3, 1 );
	layout->setColStretch( 0, 1 );
	layout->addMultiCellWidget( _listBox, 0, 3, 0, 0 );
	layout->addWidget( _pbAdd, 0, 1 );
	layout->addWidget( _pbEdit, 1, 1 );
	layout->addWidget( _pbDel, 2, 1 );

	layout->activate();

	connect( _pbAdd, SIGNAL( clicked() ), SLOT( slot_add() ) );
	connect( _pbEdit, SIGNAL( clicked() ), SLOT( slot_edit() ) );
	connect( _pbDel, SIGNAL( clicked() ), SLOT( slot_del() ) );
}

void BuildingAction::init( GenericBuildingModel * building )
{
	_building = building;
	QPtrList<Action> *  action = _building->getActionList();
	_listBox->clear();
	if( action->count() ) {
		for( uint i = 0; i < action->count(); i++ ) {
			for( int j = 0; j < action->at(i)->getElementaryNumber(); j++ ) {
				ElementaryAction * elementary = action->at(i)->getElementaryAction( j );
				
				buildingActionItem * actionItem;
				actionItem = new buildingActionItem( action->at(i)->getType(), elementary->getType(), elementary->getArg(), elementary->getCoeff() );
				_listBox->insertItem( actionItem );
			}
		}
	}
}

void BuildingAction::slot_add()
{
	DialogBuildingAction dialog;

	if( dialog.exec() ) {
		buildingActionItem * actionItem;
		Action::ActionType actionType = dialog.getActionType();
		ElementaryAction::ElementaryType ElementaryType = dialog.getModifType();
		uint param = dialog.getParam();
		int value = dialog.getValue();
		actionItem = new buildingActionItem( actionType, ElementaryType, param, value );

		_listBox->insertItem( actionItem );
	}
}

void BuildingAction::slot_edit()
{
	int item = _listBox->currentItem();
	if( item != -1 ) {
		DialogBuildingAction dialog;
		dialog.setActionType( ( (buildingActionItem*)(_listBox->item( item ) ) )->getActionType() );
		dialog.setModifType( ( (buildingActionItem*)(_listBox->item( item ) ) )->getModifType() );
		dialog.setParam( ( (buildingActionItem*)(_listBox->item( item ) ) )->getParam() );
		dialog.setValue( ( (buildingActionItem*)(_listBox->item( item ) ) )->getValue() );
		if( dialog.exec() ) {
			Action::ActionType actionType = dialog.getActionType();
			ElementaryAction::ElementaryType ElementaryType = dialog.getModifType();
			uint param = dialog.getParam();
			int value = dialog.getValue();
			buildingActionItem * action = (buildingActionItem*) _listBox->item( item );
			action->setActionType( actionType );
			action->setModifType( ElementaryType );
			action->setParam( param );
			action->setValue( value );
		}
	}
}

void BuildingAction::slot_del()
{
	int item = _listBox->currentItem();
	if( item != -1 ) {
		_listBox->removeItem( item );
	}
}

void BuildingAction::save()
{

	_building->clearActions();
	uint nb = _listBox->count();
	for( uint i = 0; i < nb; ++i ) {
		buildingActionItem * item = (buildingActionItem*) _listBox->item( i );
		ElementaryAction * eleaction = new ElementaryAction();
		eleaction->setType(item->getModifType() );
		eleaction->setArg( item->getParam() );
		eleaction->setCoeff( item->getValue() );
		Action * builAction =  new Action();
		builAction->setType(item->getActionType());
		builAction->addElementaryAction(eleaction);
		_building->addAction( builAction );
	}
}

//
// ----- buildingActionItem -----
//

buildingActionItem::buildingActionItem( Action::ActionType action,
	ElementaryAction::ElementaryType modif, uint param, int value )
: QListBoxText()
{
	_action = action;
	_modif = modif;
	_param = param;
	_value = value;
	computeLabel();
}

void buildingActionItem::computeLabel()
{
	Action * tmpa= new Action();
	tmpa->setType(_action);
	ElementaryAction * tmpe= new ElementaryAction();
	tmpe->setType(_modif);
	QString text =  QObject::tr("Action: ");
		text += tmpa->getActionTypeString( _action );
		text += QObject::tr( " elementary " );
		text += tmpe->getElemTypeString( _modif  );
		if(_modif == ElementaryAction::RESSOURCE || _modif == ElementaryAction::RANDRESSOURCE){
			text += " ( "  + DataTheme.resources.getRessource(_param) + " ) ";
		}
		text += QObject::tr( " modify by " ) + QString::number( _value );
	setText( text );
}


//
// ----- DialogbuildingAction -----
//

DialogBuildingAction::DialogBuildingAction( QWidget * parent, const char * name )
: QDialog( parent, name, true )
{
	QLabel * labAction = new QLabel( tr( "Action type: " ), this );
	FIXEDSIZE( labAction );

	_comboAction = new QComboBox( this );
	_comboAction->insertItem(tr("Date"));
	_comboAction->insertItem(tr("First Time"));
	_comboAction->insertItem(tr("First Time Lord"));
	_comboAction->insertItem(tr("Next Time"));
	FIXEDSIZE( _comboAction );

	_comboModif = new QComboBox( this );
	_comboModif->insertItem( tr( "Attack" ) );
	_comboModif->insertItem( tr( "Defense" ) );
	_comboModif->insertItem( tr( "Power" ) );
	_comboModif->insertItem( tr( "Knowledge" ) );
	_comboModif->insertItem( tr( "Move" ) );
	_comboModif->insertItem( tr( "Maxmove" ) );
	_comboModif->insertItem( tr( "TechPoint" ) );
	_comboModif->insertItem( tr( "MaxTechPoint" ) );
	_comboModif->insertItem( tr( "Morale" ) );
	_comboModif->insertItem( tr( "Luck" ) );
	_comboModif->insertItem( tr( "Vision" ) );
	_comboModif->insertItem( tr( "Experience" ) );
	_comboModif->insertItem( tr( "Skill" ) );
	_comboModif->insertItem( tr( "Artefact" ) );
	_comboModif->insertItem( tr( "Unit" ) );
	_comboModif->insertItem( tr( "Resource" ) );
	_comboModif->insertItem( tr( "Random Resource" ) );
	FIXEDSIZE( _comboAction );

	QLabel * labModif = new QLabel( tr( "Elementary Action: " ), this );
	FIXEDSIZE( labModif );

	QLabel * labParam = new QLabel( tr( "Param: " ), this );

	QLabel * labValue = new QLabel( tr( "Coeff: " ), this );
	
	_spinParam = new QSpinBox( this );
	_spinParam->setMinValue( 0 );

	_spinValue = new QSpinBox( this );
	_spinValue->setMaxValue( 100000 );

	QGridLayout * grid = new QGridLayout( 2, 6 );
	grid->addWidget( labAction, 1, 0 );
	grid->addWidget( _comboAction, 1, 1 );
	grid->addWidget( labModif, 2, 0 );
	grid->addWidget( _comboModif, 2, 1 );
	grid->addWidget( labParam, 3, 0 );
	grid->addWidget( _spinParam, 3, 1 );
	grid->addWidget( labValue, 4, 0 );
	grid->addWidget( _spinValue, 4, 1 );
	grid->addColSpacing( 0, 5 );
	grid->addColSpacing( 5, 5 );

	QPushButton * pbOk = new QPushButton( this );
	pbOk->setText( tr( "Ok" ) );
	FIXEDSIZE( pbOk );

	QPushButton * pbCan = new QPushButton( this );
	pbCan->setText( tr( "Cancel" ) );
	FIXEDSIZE( pbCan );

	QHBoxLayout * layH1 = new QHBoxLayout();
	layH1->addStretch( 1 );
	layH1->addWidget( pbCan );
	layH1->addStretch( 1 );
	layH1->addWidget( pbOk );
	layH1->addStretch( 1 );

	QVBoxLayout * layout = new QVBoxLayout( this );
	layout->setSpacing( 5 );
	layout->setMargin( 5 );
	layout->addLayout( grid, 1 );
	layout->addLayout( layH1 );
	layout->activate();

	connect( pbOk, SIGNAL( clicked() ), SLOT( accept() ) );
	connect( pbCan, SIGNAL( clicked() ), SLOT( reject() ) );
	FIXEDSIZE( this );
}

void DialogBuildingAction::updateDialog()
{
	_comboAction->setCurrentItem( (uint)_action );
	_comboModif->setCurrentItem( (uint)_modif-1 );
	_spinParam->setValue( _param );
	_spinValue->setValue( _value );
}

void DialogBuildingAction::accept()
{
	_action = (Action::ActionType) _comboAction->currentItem();
	_modif = (ElementaryAction::ElementaryType) (_comboModif->currentItem() + 1);
	_param = _spinParam->value();
	_value = _spinValue->value();

	QDialog::accept();
}

