#include "utils.h"
#include "formats.h"
#include <string.h>
#include <stdio.h>

const char* avm_wave_format_name(short fmt) 
{
    unsigned i;
    static const struct s_t {
	int16_t format;
	const char* name;
    } formats[] = {
	{ 0x0000, "Microsoft Unknown Wave Format" },
	{ WAVE_FORMAT_PCM, "Microsoft PCM" },
	{ WAVE_FORMAT_ADPCM, "Microsoft ADPCM" },
	{ WAVE_FORMAT_IEEE_FLOAT, "IEEE Float" },
	{ WAVE_FORMAT_VSELP, "Compaq Computer VSELP Ima-0ADPCM" },
	{ WAVE_FORMAT_IBM_CVSD, "IBM CVSD" },
	{ WAVE_FORMAT_ALAW, "Microsoft ALAW (CCITT A-Law)" },
	{ WAVE_FORMAT_MULAW, "Microsoft MULAW (CCITT u-Law)" },
	{ WAVE_FORMAT_DVI_ADPCM, "DVI ADPCM" },
	{ WAVE_FORMAT_GSM610,  "MS GSM 6.10" },
	{ WAVE_FORMAT_MSNAUDIO, "MSN Audio" },
	{ WAVE_FORMAT_MPEG, "MPEG Layer-1/2" },
	{ WAVE_FORMAT_MPEGLAYER3, "MPEG Layer-3" },
	{ WAVE_FORMAT_VOXWARE_BYTE_ALIGNED, },
	{ WAVE_FORMAT_VOXWARE_AC8, },
	{ WAVE_FORMAT_VOXWARE_AC10, },
	{ WAVE_FORMAT_VOXWARE_AC16, },
	{ WAVE_FORMAT_VOXWARE_RT24, },
	{ WAVE_FORMAT_VOXWARE_RT29HW, },
	{ WAVE_FORMAT_VOXWARE_VR12, },
	{ WAVE_FORMAT_VOXWARE_VR18, },
	{ WAVE_FORMAT_VOXWARE_RT29, "Voxware Metasound" },
	{ WAVE_FORMAT_SIPROLAB_ACELP4800, },
	{ WAVE_FORMAT_SIPROLAB_ACELP8V3, },
	{ WAVE_FORMAT_SIPROLAB_G729, },
	{ WAVE_FORMAT_SIPROLAB_G729A, },
	{ WAVE_FORMAT_SIPROLAB_KELVIN, },
	{ WAVE_FORMAT_SIPROLAB_ACEPLNET, "ACELP.net" },
	{ WAVE_FORMAT_MSAUDIO1, "WMA v1" },
	{ 0x0161, "WMA v2" },
	{ 0x0162, "WMA v3" },
	{ 0x0401, "Intel Music Coder" },
	{ 0x181c, "VoxWare RT24 Speech codec" },
	{ 0x1fc4, "ALF2" },
	{ WAVE_FORMAT_DVM, "AC3 DVM" },
	{ WAVE_FORMAT_EXTENSIBLE, "Extended Wave header" }
    };

    for (i = 0; i < (sizeof(formats)/sizeof(formats[0])); ++i)
	if (fmt == formats[i].format) {
	    if (formats[i].name != 0)
		return formats[i].name;
	    fmt = formats[i + 1].format; // use next string
	}
    return "unknown?";

#if 0
    * 0x0008 Microsoft DTS
    * 0x0009 Microsoft DRM
    * 0x0010 OKI ADPCM
    * 0x0011 Intel DVI ADPCM (IMA ADPCM)
    * 0x0012 Videologic MediaSpace ADPCM
    * 0x0013 Sierra Semiconductor ADPCM
    * 0x0014 Antex Electronics G.723 ADPCM
    * 0x0015 DSP Solutions DigiSTD
    * 0x0016 DSP Solutions DigiFIX
    * 0x0017 Dialogic OKI ADPCM
    * 0x0018 MediaVision ADPCM
    * 0x0019 Hewlett-Packard CU codec
    * 0x0020 Yamaha ADPCM
    * 0x0021 Speech Compression SONARC
    * 0x0022 DSP Group True Speech
    * 0x0023 Echo Speech EchoSC1
    * 0x0024 Audiofile AF36
    * 0x0025 Audio Processing Technology APTX
    * 0x0026 AudioFile AF10
    * 0x0027 Prosody 1612 codec for CTI Speech Card
    * 0x0028 Merging Technologies S.A. LRC
    * 0x0030 Dolby Labs AC2
    * 0x0031 Microsoft GSM 6.10
    * 0x0032 MSNAudio
    * 0x0033 Antex Electronics ADPCME
    * 0x0034 Control Resources VQLPC
    * 0x0035 DSP Solutions DigiREAL
    * 0x0036 DSP Solutions DigiADPCM
    * 0x0037 Control Resources CR10
    * 0x0038 Natural MicroSystems VBXADPCM
    * 0x0039 Roland RDAC (Crystal Semiconductor IMA ADPCM)
    * 0x003A Echo Speech EchoSC3
    * 0x003B Rockwell ADPCM
    * 0x003C Rockwell Digit LK
    * 0x003D Xebec Multimedia Solutions
    * 0x0040 Antex Electronics G.721 ADPCM
    * 0x0041 Antex Electronics G.728 CELP
    * 0x0042 Microsoft MSG723
    * 0x0043 IBM AVC ADPCM
    * 0x0045 ITU-T G.726 ADPCM
    * 0x0050 MPEG-1 layer 1, 2
    * 0x0052 InSoft RT24 (ACM codec is an alternative codec)
    * 0x0053 InSoft PAC
    * 0x0055 MPEG-1 Layer 3 (MP3)
    * 0x0059 Lucent G.723
    * 0x0060 Cirrus Logic
    * 0x0061 ESS Technology ESPCM / Duck DK4 ADPCM
    * 0x0062 Voxware file-mode codec / Duck DK3 ADPCM
    * 0x0063 Canopus Atrac
    * 0x0064 APICOM G.726 ADPCM
    * 0x0065 APICOM G.722 ADPCM
    * 0x0066 Microsoft DSAT
    * 0x0067 Microsoft DSAT Display
    * 0x0069 Voxware Byte Aligned (bitstream-mode codec)
    * 0x0070 Voxware AC8 (Lernout & Hauspie CELP 4.8 kbps)
    * 0x0071 Voxware AC10 (Lernout & Hauspie CBS 8kbps)
    * 0x0072 Voxware AC16 (Lernout & Hauspie CBS 12kbps)
    * 0x0073 Voxware AC20 (Lernout & Hauspie CBS 16kbps)
    * 0x0074 Voxware MetaVoice (file and stream oriented)
    * 0x0075 Voxware MetaSound (file and stream oriented)
    * 0x0076 Voxware RT29HW
    * 0x0077 Voxware VR12
    * 0x0078 Voxware VR18
    * 0x0079 Voxware TQ40
    * 0x0080 Softsound
    * 0x0081 Voxware TQ60
    * 0x0082 Microsoft MSRT24 (ACM codec is an alternative codec)
    * 0x0083 AT&T Labs G.729A
    * 0x0084 Motion Pixels MVI MV12
    * 0x0085 DataFusion Systems G.726
    * 0x0086 DataFusion Systems GSM610
    * 0x0088 Iterated Systems ISIAudio
    * 0x0089 Onlive
    * 0x0091 Siemens Business Communications SBC24
    * 0x0092 Sonic Foundry Dolby AC3 SPDIF
    * 0x0093 MediaSonic G.723
    * 0x0094 Aculab PLC Prosody 8KBPS
    * 0x0097 ZyXEL ADPCM
    * 0x0098 Philips LPCBB
    * 0x0099 Studer Professional Audio AG Packed
    * 0x00A0 Malden Electronics PHONYTALK
    * 0x00FF AAC
    * 0x0100 Rhetorex ADPCM
    * 0x0101 IBM mu-law / BeCubed Software IRAT
    * 0x0102 IBM A-law
    * 0x0103 IBM AVC ADPCM
    * 0x0111 Vivo G.723
    * 0x0112 Vivo Siren
    * 0x0123 Digital G.723
    * 0x0125 Sanyo LD ADPCM
    * 0x0130 Sipro Lab Telecom ACELP.net
    * 0x0131 Sipro Lab Telecom ACELP.4800
    * 0x0132 Sipro Lab Telecom ACELP.8V3
    * 0x0133 Sipro Lab Telecom ACELP.G.729
    * 0x0134 Sipro Lab Telecom ACELP.G.729A
    * 0x0135 Sipro Lab Telecom ACELP.KELVIN
    * 0x0140 Dictaphone G.726 ADPCM
    * 0x0150 Qualcomm PureVoice
    * 0x0151 Qualcomm HalfRate
    * 0x0155 Ring Zero Systems TUB GSM
    * 0x0160 Windows Media Audio V1 / DivX audio (WMA)
    * 0x0161 Windows Media Audio V2 V7 V8 V9 / DivX audio (WMA) / Alex AC3 Audio
    * 0x0162 Windows Media Audio Professional V9
    * 0x0163 Windows Media Audio Lossless V9
    * 0x0170 UNISYS NAP ADPCM
    * 0x0171 UNISYS NAP ULAW
    * 0x0172 UNISYS NAP ALAW
    * 0x0173 UNISYS NAP 16K
    * 0x0200 Creative Labs ADPCM
    * 0x0202 Creative Labs FastSpeech8
    * 0x0203 Creative Labs FastSpeech10
    * 0x0210 UHER Informatic ADPCM
    * 0x0215 Ulead DV ACM
    * 0x0216 Ulead DV ACM
    * 0x0220 Quarterdeck
    * 0x0230 I-link Worldwide ILINK VC
    * 0x0240 Aureal Semiconductor RAW SPORT
    * 0x0241 ESST AC3
    * 0x0250 Interactive Products HSX
    * 0x0251 Interactive Products RPELP
    * 0x0260 Consistent Software CS2
    * 0x0270 Sony ATRAC3 (SCX, same as MiniDisk LP2)
    * 0x0300 Fujitsu FM TOWNS SND
    * 0x0400 BTV Digital (Brooktree digital audio format)
    * 0x0401 Intel Music Coder (IMC)
    * 0x0402 Ligos Indeo Audio
    * 0x0450 QDesign Music
    * 0x0680 AT&T Labs VME VMPCM
    * 0x0681 AT&T Labs TPC
    * 0x0700 YMPEG Alpha (dummy for MPEG-2 compressor)
    * 0x08AE ClearJump LiteWave
    * 0x1000 Olivetti GSM
    * 0x1001 Olivetti ADPCM
    * 0x1002 Olivetti CELP
    * 0x1003 Olivetti SBC
    * 0x1004 Olivetti OPR
    * 0x1100 Lernout & Hauspie codec
    * 0x1101 Lernout & Hauspie CELP codec
    * 0x1102 Lernout & Hauspie SBC codec
    * 0x1103 Lernout & Hauspie SBC codec
    * 0x1104 Lernout & Hauspie SBC codec
    * 0x1400 Norris Communication
    * 0x1401 AT&T Labs ISIAudio
    * 0x1500 AT&T Labs Soundspace Music Compression
    * 0x181C VoxWare RT24 speech codec
    * 0x181E Lucent elemedia AX24000P Music codec
    * 0x1C07 Lucent SX8300P speech codec
    * 0x1C0C Lucent SX5363S G.723 compliant codec
    * 0x1F03 CUseeMe DigiTalk (ex-Rocwell)
    * 0x1FC4 NCT Soft ALF2CD ACM
    * 0x2000 Dolby AC3 / FAST Multimedia AG DVM
    * 0x2001 Dolby DTS (Digital Theater System)
    * 0x2002 RealAudio 1 / 2 14.4
    * 0x2003 RealAudio 1 / 2 28.8
    * 0x2004 RealAudio G2 / 8 Cook (low bitrate)
    * 0x2005 RealAudio 3 / 4 / 5 Music (DNET)
    * 0x2006 RealAudio 10 AAC (RAAC)
    * 0x2007 RealAudio 10 AAC+ (RACP)
    * 0x3313 makeAVIS (ffvfw fake AVI sound from AviSynth scripts)
    * 0x4143 Divio MPEG-4 AAC audio
    * 0x434C LEAD Speech
    * 0x564C LEAD Vorbis
    * 0x674f Ogg Vorbis (mode 1)
    * 0x6750 Ogg Vorbis (mode 2)
    * 0x6751 Ogg Vorbis (mode 3)
    * 0x676f Ogg Vorbis (mode 1+)
    * 0x6770 Ogg Vorbis (mode 2+)
    * 0x6771 Ogg Vorbis (mode 3+)
    * 0x7A21 GSM-AMR (CBR, no SID)
    * 0x7A22 GSM-AMR (VBR, including SID)
    * 0xDFAC DebugMode SonicFoundry Vegas FrameServer ACM Codec
    * 0xF1AC Free Lossless Audio Codec FLAC
    * 0xFFFE Extensible wave format
    * 0xFFFF In Development / Unregistered 
#endif
}

char* avm_wave_format(char* buf, uint_t s, const WAVEFORMATEX* wf) 
{
    if (buf)
    {
	char b[200];
	int c = sprintf(b, "fmt=0x%02x %uch %uHz %2ub %6uB/s balign=%u cbsz=%u",
			wf->wFormatTag, wf->nChannels, wf->nSamplesPerSec,
			wf->wBitsPerSample, wf->nAvgBytesPerSec,
			wf->nBlockAlign, wf->cbSize);
	if (c >= --s)
	    b[c] = 0;
	strcpy(buf, b);
    }
    return buf;
}

char* avm_mp3wave_format(char* buf, uint_t s, const MP3WAVEFORMATEX* wf)
{
    if (buf)
    {
	static const char* ids[] = { "Unknown", "MPEG", "ConstanFrameSize" };
	static const char* flags[] = { "PaddingISO", "PaddingOn", "PaddingOff" };
	char b[200];

	int c = sprintf(b, "ID=%d (%s) flags=%d (%s) blocksize=%d frms/blk=%d delay=%d",
			wf->wID, ids[wf->wID],  wf->fdwFlags, flags[wf->fdwFlags],
			wf->nBlockSize, wf->nFramesPerBlock, wf->nCodecDelay);
	if (c >= --s)
	    b[c] = 0;
	strcpy(buf, b);
    }
    return buf;
}
