/*
   io1200.h - internal register definitions for AT90S1200

   Contributors:
     Created by Marek Michalkiewicz <marekm@linux.org.pl>

   THIS SOFTWARE IS NOT COPYRIGHTED

   This source code is offered for use in the public domain.  You may
   use, modify or distribute it freely.

   This code is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
   DISCLAIMED.  This includes but is not limited to warranties of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

   Based on Atmel datasheet Rev. 0838E-04/99.
 */

#ifndef __IO1200
#define __IO1200

#ifndef __ASSEMBLER__
#  warning "MCU not supported by the C compiler"
#endif

/* I/O space addresses */

/* 0x00..0x07 reserved */

/* Analog Comparator Control and Status Register */
#define ACSR	0x08

/* 0x09..0x0F reserved */

#define PIND	0x10
#define DDRD	0x11
#define PORTD	0x12

/* 0x13..0x15 reserved */

#define PINB	0x16
#define DDRB	0x17
#define PORTB	0x18

/* 0x19..0x1B reserved */

#define EECR	0x1C
#define EEDR	0x1D
#define EEARL	0x1E

/* 0x1F..0x20 reserved */

/* Watchdog Timer Control Register */
#define WDTCR	0x21

/* 0x22..0x31 reserved */

#define TCNT0	0x32
#define TCCR0	0x33

/* 0x34 reserved */

#define MCUCR	0x35

/* 0x36..0x37 reserved */

/* Timer/Counter Interrupt Flag Register */
#define TIFR	0x38

/* Timer/Counter Interrupt MaSK Register */
#define TIMSK	0x39

/* 0x3A reserved */

#define GIMSK	0x3B

/* 0x3C..0x3E reserved */

#define SREG	0x3F

/* Interrupt vectors (byte addresses) */

#define SIG_INTERRUPT0		_vector_1
#define SIG_OVERFLOW0		_vector_2
#define SIG_ADC			_vector_3

#define END_VECTOR		(3)
#define INT_VECT_SIZE (0x08)

/* Bit numbers */

/* GIMSK */
#define INT0	6

/* TIMSK */
#define TOIE0	1

/* TIFR */
#define TOV0	1

/* MCUCR */
#define SE	5
#define SM	4
#define ISC01	1
#define ISC00	0

/* TCCR0 */
#define CS02	2
#define CS01	1
#define CS00	0

/* WDTCR */
#define WDE	3
#define WDP2	2
#define WDP1	1
#define WDP0	0

/* EECR */
#define EEWE	1
#define EERE	0

/*
   PB7 = SCK
   PB6 = MISO
   PB5 = MOSI
   PB1 = AIN1
   PB0 = AIN0
 */

/* PORTB */
#define PB7	7
#define PB6	6
#define PB5	5
#define PB4	4
#define PB3	3
#define PB2	2
#define PB1	1
#define PB0	0

/* DDRB */
#define DDB7	7
#define DDB6	6
#define DDB5	5
#define DDB4	4
#define DDB3	3
#define DDB2	2
#define DDB1	1
#define DDB0	0

/* PINB */
#define PINB7	7
#define PINB6	6
#define PINB5	5
#define PINB4	4
#define PINB3	3
#define PINB2	2
#define PINB1	1
#define PINB0	0

/* PORTD */
#define PD6	6
#define PD5	5
#define PD4	4
#define PD3	3
#define PD2	2
#define PD1	1
#define PD0	0

/* DDRD */
#define DDD6	6
#define DDD5	5
#define DDD4	4
#define DDD3	3
#define DDD2	2
#define DDD1	1
#define DDD0	0

/* PIND */
#define PIND6	6
#define PIND5	5
#define PIND4	4
#define PIND3	3
#define PIND2	2
#define PIND1	1
#define PIND0	0

/* ACSR */
#define ACD	7
#define ACO	5
#define ACI	4
#define ACIE	3
#define ACIS1	1
#define ACIS0	0

#define ZL r30

/* Last memory addresses */
#define RAMEND		0x1F
#define XRAMEND		0x0
#define E2END		0x3F
#define FLASHEND	0x3FF

#endif  /* __IO1200 */
