/*
   strcasecmp.S
   Case insensitive compare

   Contributors:
     Created by Reiner Patommel

   THIS SOFTWARE IS NOT COPYRIGHTED

   This source code is offered for use in the public domain.  You may
   use, modify or distribute it freely.

   This code is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
   DISCLAIMED.  This includes but is not limited to warranties of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/
#include "macros.inc"

#define s1_hi r25
#define s1_lo r24
#define s2_hi r23
#define s2_lo r22

#define ret_hi r25
#define ret_lo r24

#define tmp r22
#define cht r21

; int strcasecmp(const char *s1, const char *s2)

    .text
    .global _U(strcasecmp)
    .type   _U(strcasecmp), @function
_U(strcasecmp):
    LOAD_Z(s2_lo, s2_hi)
    LOAD_X(s1_lo, s1_hi)
.strcasecmp_loop:
    LD    ret_lo, X+          ; load *s1
    LD    tmp, Z+             ; load *s2
    MOV   cht, tmp            ; copy of *s2 to tmp
    ORI   cht, 0x20           ; make tmp lower case
    CPI   cht, 'a'            ; test on [a .. z]
	BRLT  .strcasecmp_tst
    CPI   cht, 'z'+1
	BRGE  .strcasecmp_tst
    ORI   tmp, 0x20           ; we got an aplpha in s2
    ORI   ret_lo, 0x20
.strcasecmp_tst:                 ; compare
    SUB   ret_lo, tmp
    BRNE  .strcasecmp_done
    TST   tmp                 ; end of s2?
    BRNE  .strcasecmp_loop
.strcasecmp_done:
; ret_hi = SREG.C ? 0xFF : 0
    SBC   ret_hi, ret_hi
    RET
.strcasecmp_end:
    .size   _U(strcasecmp), .strcasecmp_end - _U(strcasecmp)

