/*
   strlwr.S
   convert a string to lower case

   Contributors:
     Created by Reiner Patommel

   THIS SOFTWARE IS NOT COPYRIGHTED

   This source code is offered for use in the public domain.  You may
   use, modify or distribute it freely.

   This code is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
   DISCLAIMED.  This includes but is not limited to warranties of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/
#include "macros.inc"

#define str_hi r25
#define str_lo r24
#define temp   r21

; char *strlwr(char *string)

    .text
    .global _U(strlwr)
    .type   _U(strlwr), @function

_U(strlwr):
    LOAD_X(str_lo, str_hi)
.strlwr_loop:
    LD    temp, X           ; get 1st character
    TST   temp              ; is it end of string
    BREQ  .strlwr_done
    ORI   temp, 0x20        ; make lower case
    CPI   temp, 'a'         ; test on [a .. z]
    BRLT  .strlwr_next
    CPI   temp, 'z'+1
    BRGE  .strlwr_next
    ST    X, temp           ; ok, it is a char --> store it
.strlwr_next:
    ADIW  XL, 1				; point to next character
	RJMP  .strlwr_loop
.strlwr_done:
    RET
.strlwr_end:
	.size _U(strlwr), .strlwr_end - _U(strlwr)
