/*
   strrev.S
   Reverse a string

   Contributors:
     Created by Reiner Patommel

   THIS SOFTWARE IS NOT COPYRIGHTED

   This source code is offered for use in the public domain.  You may
   use, modify or distribute it freely.

   This code is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
   DISCLAIMED.  This includes but is not limited to warranties of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/
#include "macros.inc"

#define str_hi r25
#define str_lo r24
#define ltemp  r23
#define rtemp  r22

; char *strrev(char *string)

    .text
    .global _U(strrev)
    .type   _U(strrev), @function

_U(strrev):
    LOAD_X(str_lo, str_hi)	; X is start of string
	LOAD_Z(str_lo, str_hi)	; Z becomes end of string
.strrev_eos:
	LD    __tmp_reg__, Z+
	TST   __tmp_reg__
	BRNE  .strrev_eos
	SBIW  ZL, 2				; now Z points at end of string
.strrev_loop:
	CP    XL, ZL
	CPC   XH, ZH			; if X >= Z we are done
	BRSH  .strrev_done
	LD    ltemp, X          ; get left character
	LD    rtemp, Z			; get right character
	ST    Z, ltemp
	SBIW  ZL, 1
	ST    X+, rtemp			; swap chars
	RJMP  .strrev_loop		; next pair
.strrev_done:
    RET
.strrev_end:
	.size _U(strrev), .strrev_end - _U(strrev)
