#!/bin/sh
# Upgrade all Axyl databases in the Axyl installation on this machine.

# NOTE: This can be run standalone, however The Debian postinst script
# usually runs this as part of the package upgrade process.
# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

# Get common funcs and config vars etc.
# Acquire the local configuration..
CONFDIR=/etc/axyl
CONF=${CONFDIR}/axyl.conf
if [ ! -f $CONF ] ; then
  echo "Axyl configuration file $CONF not found!"
  exit 2
else
  . $CONF
  if [ ! -d $AXYL_HOME ] ; then
    echo "FATAL: the Axyl root directory '$AXYL_HOME' does not exist."
    exit 6
  fi
  . ${AXYL_HOME}/install/axyl-common.sh
fi

# This script requires that Axyl is properly installed. If it isn't
# then the following vars will not be defined, which is an error.
if [ "$AXUSER" = "" -o "$AXYL_DATA" = "" ] ; then
  echo "ERROR: Axyl is not configured properly and one of AXUSER, and/or"
  echo "AXYL_DATA are undefined. Check /etc/axyl/axyl.conf exists and"
  echo "contains these settings. Otherwise, do you need to run script"
  echo "./setup-axyl.sh first?"
  exit 1
fi


# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# We can be called in either Upgrade, or Stamp mode. The former will
# do a full Db upgrade, whilst the latter only stamps the DB with
# the Axyl version number.
UPGRADE_MODE=$1
AXYL_SYSTEM=${AXYL_DATA}/system
AXYL_DB=${AXYL_SYSTEM}/axyl_websites.csv
if [ -d $AXYL_SYSTEM ] ; then
  if [ -f $AXYL_DB ] ; then
    (while read dbline ; do
      # APPNAME,DBTYPE,DBNAME,DBUSER,DBPASSWD,DBHOST,DBPORT,DOCROOT,VHOST,SERVERNAME,ADMIN_EMAIL
      A=`echo $dbline | perl -n -e "m;^#; && print;"`
      if [ "$A" = "" ] ; then
        APPNAME=`echo $dbline | cut -d',' -f1`
        DBTYPE=`echo $dbline | cut -d',' -f2`
        DBNAME=`echo $dbline | cut -d',' -f3`
        DBUSER=`echo $dbline | cut -d',' -f4`
        DBPASSWD=`echo $dbline | cut -d',' -f5`
        DBHOST=`echo $dbline | cut -d',' -f6`
        DBPORT=`echo $dbline | cut -d',' -f7`
        # Run the appropriate database patcher, if present..
        if [ -x ${AXYL_HOME}/db/${DBTYPE}/upgrade-db.sh ] ; then
          . ${AXYL_HOME}/db/${DBTYPE}/upgrade-db.sh $DBNAME $DBUSER $DBPASSWD $DBHOST $DBPORT $AXYL_VERSION $UPGRADE_MODE
        fi
      fi
    done) < $AXYL_DB 
  fi
fi

# END