<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    common.inc                                              */
/* Author:      Paul Waite                                              */
/* Description: Common pre-amble to any Axyl script. Makes checks, and  */
/*              opens logfiles, loads Postgres etc. etc.                */
/*                                                                      */
/* ******************************************************************** */

// DOUBLE-CHECK AXYL INSTALLATION SANITY
if (!is_dir("$AXYL_HOME/db/postgres")) {
  die(
    "Your Axyl installation at $AXYL_HOME doesn't check out.\n"
  . "The 'db/postgres' sub-directory is not there."
  );
}
elseif (!is_dir("$AXYL_HOME/www")) {
  die(
    "Your Axyl installation at $AXYL_HOME doesn't check out.\n"
  . "The 'www' sub-directory is not there."
  );
}
elseif (!is_dir("$AXYL_LOGS")) {
  die(
    "Your Axyl installation doesn't check out.\n"
  . "The $AXYL_LOGS directory is not present."
  );
}

// ----------------------------------------------------------------------
// INCLUDE REQUIRED FUNCTIONS
include_once("$AXYL_HOME/scripts/inc/utility-funcs.inc");

if ($POSTGRES_REQD) {
  include_once("$AXYL_HOME/scripts/inc/postgres-funcs.inc");
}

// ----------------------------------------------------------------------
// ROOT CHECK..
if ($ROOT_REQD) {
  $uid = shell_exec("id -u");
  if ($uid != 0) {
    die("You must be root to run this script.\n");
  }
}

// ----------------------------------------------------------------------
// STDIN File Handle..
if ($USER_INPUT) {
  $STDIN = fopen("php://stdin", "r");
  if ($STDIN === false) {
    die("FATAL: could not open STDIN stream for user input\n");
  }
}

// ----------------------------------------------------------------------
// POSTGRES IS REQUIRED
if ($POSTGRES_REQD) {
  if (!extension_loaded("pgsql")) {
    if (!dl("pgsql.so")) {
      exit;
    }
  }
  if (!extension_loaded("pgsql")) {
    die("FATAL: failed to load Postgres PHP extension pgsql.so.\n");
  }
}

// ----------------------------------------------------------------------
// AXYL WEBSITE ROOT IS REQUIRED
if ($AXYLROOT_REQD) {
  if (!file_exists("application.xml") || !is_dir("lib")) {
    die("FATAL: script is not being run from an Axyl website root directory\n");
  }
}

// ----------------------------------------------------------------------
// LOGGING
if (!isset($AXYL_LOGS)) {
  $AXYL_LOGS = "/tmp";
  debug("Axyl logging directory undefined, falling back to $AXYL_LOGS");
}
$LOGFILE = "$AXYL_LOGS/$PROGNAME.log";
$LOG = fopen($LOGFILE, "a");
if ($LOG === false) {
  die("FATAL: could not open logfile $LOGFILE for append.\n");
}
else {
  debug("$PROGNAME $PROGVER");
 // register_shutdown_function("closelogfile");
}

?>