<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    postgres-funcs.inc                                      */
/* Author:      Paul Waite                                              */
/* Description: Generic stripped-down Postgres access functions for     */
/*              various scripts which require DB access.                */
/*                                                                      */
/* ******************************************************************** */

function connect_pgdb($dbname, $dbuser="", $dbpass="", $dbhost="", $dbport=0) {
  $connstr = " dbname=" . $dbname;
  if ($dbuser != "") $connstr .= " user=" . $dbuser;
  if ($dbpass != "") $connstr .= " password=" . $dbpass;
  if ($dbhost != "") $connstr .= " host=" . $dbhost;
  if ($dbport != 0 ) $connstr .= " port=" . $dbport;
  $connstr = trim($connstr);
  return pg_connect($connstr);
}

function disconnect_pgdb($dbid) {
  if ($dbid !== false) {
    pg_close($dbid);
  }
}

function query_pgdb($dbid, $sql) {
  global $DEBUGMODE;
  if (PHP_VERSION >= 4.2) {
    $rid = pg_query($dbid, $sql);
  }
  else {
    $rid = pg_exec($dbid, $sql);
  }
  if ($rid === false) {
    logit("QFAIL: $sql");
    $pgerr = trim(errormessage($dbid));
    if ($pgerr != "") {
      logit("POSTGRES ERROR: $pgerr");
    }
  }
  elseif (isset($DEBUGMODE) && $DEBUGMODE == true) {
    logit("QOK: $sql");
  }
  return $rid;
}

function errormessage($dbid) {
  if (PHP_VERSION >= 4.2) return pg_last_error($dbid);
  else return pg_errormessage($dbid);
}

function numrows_pgdb($rid) {
  if (PHP_VERSION >= 4.2) return pg_num_rows($rid);
  else return pg_numrows($rid);
}

function fetch_array_pgdb($rid, $rowno) {
  return pg_fetch_array($rid, $rowno);
}

?>