#!/bin/sh
# Un-register an Axyl website from our CSV database
# Paul Waite
#
# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
set -e

# Get common funcs and config vars etc.
# Acquire the local configuration..
CONFDIR=/etc/axyl
CONF=${CONFDIR}/axyl.conf
if [ ! -f $CONF ]
then
  echo "Axyl configuration file $CONF not found!"
  exit 2
else
  . $CONF
  if [ ! -d $AXYL_HOME ] ; then
    echo "FATAL: the Axyl root directory '$AXYL_HOME' does not exist."
    exit 6
  fi
  . ${AXYL_HOME}/install/axyl-common.sh
fi

# This script requires that Axyl is properly installed. If it isn't
# then the following vars will not be defined, which is an error.
if [ "$AXUSER" = "" -o "$AXYL_DATA" = "" ]
then
  echo "ERROR: Axyl is not configured properly and one of AXUSER, and/or"
  echo "AXYL_DATA are undefined. Check /etc/axyl/axyl.conf exists and"
  echo "contains these settings. Otherwise, do you need to run script"
  echo "./setup-axyl.sh first?"
  exit 1
fi

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# INCOMING PARAMETERS
#  $1  - APP_NAME
APP_NAME=""

POS=0
while [ $# -gt 0 ] ; do
  POS=`expr $POS + 1`
  case $POS in
    1)  APP_NAME=$1
        ;;
  esac
  shift
done

if [ "$APP_NAME" = "" ]
then
  echo "ERROR: unregister-axyl-website.sh: parameters."
  echo "usage: unregister-axyl-website.sh app_name"
  exit 0
fi

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# Update Axyl websites database
AXYL_SYSTEM=${AXYL_DATA}/system
AXYL_DB=${AXYL_SYSTEM}/axyl_websites.csv
mkaxyldir ${AXYL_SYSTEM}
if [ -d $AXYL_SYSTEM ]
then
  chown ${AXUSER}.${AXUSER} ${AXYL_SYSTEM}
  chmod 0775 ${AXYL_SYSTEM}
  if [ ! -f $AXYL_DB ]
  then
    echo "# Axyl Website Database" >${AXYL_DB}
    echo "# APPNAME,DBTYPE,DBNAME,DBUSER,DBPASSWD,DBHOST,DBPORT,DOCROOT,VHOST,SERVERNAME,ADMIN_EMAIL" >>${AXYL_DB}
    chown $AXUSER:$AXUSER ${AXYL_DB}
    chmod 0664 ${AXYL_DB}
  fi
  AXYL_DB_NEW=`tempfile --prefix db` || true
  >$AXYL_DB_NEW
  cat $AXYL_DB | (while read dbline ; do
    A=`echo $dbline | perl -n -e "m;^${APP_NAME},; && print;"`
    if [ "$A" = "" ] ; then
      echo $dbline >> $AXYL_DB_NEW
    fi
  done)
  mv $AXYL_DB $AXYL_DB.bak
  mv $AXYL_DB_NEW $AXYL_DB
fi

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

# END