/*
 * Created on 23-Jun-2004
 * Created by Paul Gardner
 * Copyright (C) 2004, 2005, 2006 Aelitis, All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * AELITIS, SAS au capital de 46,603.30 euros
 * 8 Allee Lenotre, La Grille Royale, 78600 Le Mesnil le Roi, France.
 *
 */

package org.gudy.azureus2.plugins.torrent;

/**
 * @author parg
 *
 */

public interface 
TorrentAttribute 
{
	public static final String	TA_CATEGORY						= "Category";
	public static final String	TA_NETWORKS						= "Networks";
	public static final String	TA_PEER_SOURCES					= "PeerSources";
	public static final String	TA_TRACKER_CLIENT_EXTENSIONS	= "TrackerClientExtensions";
	public static final String	TA_SHARE_PROPERTIES				= "ShareProperties";	// private=true/false;dht_backup=true/false
	public static final String  TA_DISPLAY_NAME                 = "DisplayName";
	public static final String  TA_CONTENT_MAP                 = "ContentMap";
	

	public String
	getName();
	
		/**
		 * Returns the currently defined values for this attribute
		 * @return
		 */
	
	public String[]
	getDefinedValues();
	
		/**
		 * Adds a new value to the attribute set
		 * @param name
		 */
	
	public void
	addDefinedValue(
		String		name );
	
		/**
		 * Removes a value from the attribute set
		 * @param name
		 */
	
	public void
	removeDefinedValue(
		String		name );
	
	public void
	addTorrentAttributeListener(
		TorrentAttributeListener	l );
	
	public void
	removeTorrentAttributeListener(
		TorrentAttributeListener	l );
	
	
}
