/*
 *  bandwidthcalc.c - provide the main window
 *  Copyright (c) 2007 Christoph Goehre <christoph.goehre@gmx.de>
 *
 *  This file is part of the bandwidthcalc package.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include "callbacks.h"
#include "speedo.h"

GtkWidget *en_bandwidth;
GtkWidget *en_filesize;
GtkWidget *la_transfertime;
GtkWidget *entry;
GtkWidget *combo;
GtkWidget *window;
GdkPixbuf *pixbuf;

int main ( int argc, char *argv[] )
{
    GtkWidget *bu_ok;
    GtkWidget *bu_quit;
    GtkWidget *bu_about;
    GtkWidget *vbox;
    GtkWidget *hbox1;
    GtkWidget *hbox2;
    GtkWidget *hbox3;
    GtkWidget *hbox4;
    GtkWidget *label;

    gtk_init (&argc, &argv);
    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_window_set_title (GTK_WINDOW (window), "Bandwidth Calc");
    gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
    gtk_window_set_resizable (GTK_WINDOW (window), FALSE);
    g_signal_connect (G_OBJECT (window), "delete_event",
                      G_CALLBACK (delete_event), NULL);

    pixbuf = gdk_pixbuf_new_from_inline (-1, speedo, FALSE, NULL);
    gtk_window_set_icon (GTK_WINDOW (window), pixbuf);

    vbox = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (vbox);
    gtk_container_add (GTK_CONTAINER (window), vbox);

    hbox1 = gtk_hbox_new (FALSE, 0);
    gtk_widget_show (hbox1);
    gtk_box_pack_start (GTK_BOX (vbox), hbox1, TRUE, TRUE, 0);

    hbox2 = gtk_hbox_new (FALSE, 0);
    gtk_widget_show (hbox2);
    gtk_box_pack_start (GTK_BOX (vbox), hbox2, TRUE, TRUE, 0);

    hbox3 = gtk_hbox_new (FALSE, 0);
    gtk_widget_show (hbox3);
    gtk_box_pack_start (GTK_BOX (vbox), hbox3, TRUE, TRUE, 3);

    hbox4 = gtk_hbox_new (FALSE, 0);
    gtk_widget_show (hbox4);
    gtk_box_pack_start (GTK_BOX (vbox), hbox4, TRUE, TRUE, 0);

    /*
     * bandwidth
     */

    /* create label */
    label = gtk_label_new (" Bandwidth: ");
    gtk_box_pack_start (GTK_BOX (hbox1), label, FALSE, FALSE, 0);
    gtk_widget_set_size_request (label, 98, -1);
    gtk_label_set_use_markup (GTK_LABEL (label), TRUE);
    gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
    gtk_widget_show (label);

    /* create entry */
    en_bandwidth = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox1), en_bandwidth, FALSE, TRUE,  0);
    gtk_widget_set_size_request (en_bandwidth, 90, -1);
    gtk_widget_show (en_bandwidth);

    /* create combo */
    combo = gtk_combo_box_new_text ();
    gtk_box_pack_start (GTK_BOX (hbox1), combo, FALSE, TRUE, 0);
    gtk_widget_set_size_request (combo, 90, -1);
    gtk_combo_box_append_text (GTK_COMBO_BOX (combo), "kBit/s");
    gtk_combo_box_append_text (GTK_COMBO_BOX (combo), "kByte/s");
    gtk_combo_box_append_text (GTK_COMBO_BOX (combo), "MBit/s");
    gtk_combo_box_append_text (GTK_COMBO_BOX (combo), "MByte/s");
    gtk_combo_box_set_active (GTK_COMBO_BOX (combo), 0);
    gtk_widget_show (combo);

    /*
     * filesize
     */

    /* create label */
    label = gtk_label_new (" Filesize: ");
    gtk_box_pack_start (GTK_BOX (hbox2), label, FALSE, FALSE, 0);
    gtk_widget_set_size_request (label, 98, -1);
    gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
    gtk_widget_show (label);

    /* create entry */
    en_filesize = gtk_entry_new ();
    gtk_box_pack_start (GTK_BOX (hbox2), en_filesize, FALSE, TRUE,  0);
    gtk_widget_set_size_request (en_filesize, 90, -1);
    gtk_widget_show (en_filesize);

    /* create label */
    label = gtk_label_new ("MB");
    gtk_box_pack_start (GTK_BOX (hbox2), label, FALSE, FALSE, 2);
    gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
    gtk_widget_show (label);

    /*
     * transfertime
     */

    /* create label */
    label = gtk_label_new (" Transfertime: ");
    gtk_box_pack_start (GTK_BOX (hbox3), label, FALSE, FALSE, 0);
    gtk_widget_set_size_request (label, 98, -1);
    gtk_misc_set_alignment (GTK_MISC (label), 0, 0.5);
    gtk_widget_show (label);

    /* create entry */
    la_transfertime = gtk_label_new ("0h 0min 0sec");
    gtk_box_pack_start (GTK_BOX (hbox3), la_transfertime, FALSE, FALSE, 0);
    gtk_widget_show (la_transfertime);

    /*
     * buttons
     */

    /* create ok butten - will be calculate */
    bu_ok = gtk_button_new_from_stock ("gtk-ok");
    gtk_box_pack_start (GTK_BOX (hbox4), bu_ok, FALSE, FALSE, 0);
    gtk_widget_set_size_request (bu_ok, 93, -1);
    g_signal_connect (G_OBJECT (bu_ok), "clicked",
                      G_CALLBACK (calculate), NULL); 
    gtk_widget_show (bu_ok);

    /* create quit button */
    bu_quit = gtk_button_new_from_stock ("gtk-quit");
    gtk_box_pack_start (GTK_BOX (hbox4), bu_quit, FALSE, FALSE, 0);
    gtk_widget_set_size_request (bu_quit, 93, -1);
    g_signal_connect (G_OBJECT (bu_quit), "clicked",
                      G_CALLBACK (delete_event), NULL);
    gtk_widget_show (bu_quit);

    /* create about button - will show about dialog */
    bu_about = gtk_button_new_from_stock ("gtk-about");
    gtk_box_pack_start (GTK_BOX (hbox4), bu_about, FALSE, FALSE, 0);
    gtk_widget_set_size_request (bu_about, 93, -1);
    g_signal_connect (G_OBJECT (bu_about), "clicked",
                      G_CALLBACK (about), NULL); 
    gtk_widget_show (bu_about);

    gtk_widget_show (window);

    gtk_main ();

    return 0;
}
