/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastien.laout@tuxfamily.org                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qlayout.h>
#include <ktoolbarbutton.h>
#include <qlabel.h>
#include <klineedit.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kglobalsettings.h>

#include "search.h"
#include "settings.h"

/** SearchBar */

SearchBar::SearchBar(QWidget *parent, const char *name)
 : QWidget(parent, name), m_blinkTimer(this), m_blinkedTimes(0)
{
	QHBoxLayout *hBox  = new QHBoxLayout(this, /*margin*/0, /*spacing*/0);

	m_resetButton      = new KToolBarButton("locationbar_erase", 0, this);
	m_lineEdit         = new KLineEdit(this);
	QLabel      *label = new QLabel(m_lineEdit, i18n("Sea&rch: "), this);

	m_resetButton->setEnabled(false);

	hBox->addWidget(m_resetButton);
	hBox->addWidget(label);
	hBox->addWidget(m_lineEdit);

	m_data = new SearchData();

	connect( &m_blinkTimer,  SIGNAL(timeout()),                   this, SLOT(blinkBar())                  );
	connect(  m_lineEdit,    SIGNAL(textChanged(const QString&)), this, SLOT(textChanged(const QString&)) );
	connect(  m_resetButton, SIGNAL(clicked()),                   this, SLOT(reset())                     );
}

SearchBar::~SearchBar()
{
}

void SearchBar::reset()
{
	m_lineEdit->setText(""); // m_data->isSearching will be set to false;
}

void SearchBar::setEditFocus()
{
	m_lineEdit->setFocus();
}

bool SearchBar::hasEditFocus()
{
	return m_lineEdit->hasFocus();
}

const SearchData& SearchBar::searchData()
{
	return *m_data;
}

void SearchBar::textChanged(const QString &text)
{
	m_data->string = text;
	if (text.isEmpty()) {
		m_data->isSearching = false;
		m_resetButton->setEnabled(false);
		emit resetSearch();
	} else {
		m_data->isSearching = true;
		m_resetButton->setEnabled(true);
		emit newSearch(*m_data);
	}
}

void SearchBar::show()
{
	const int freq = 1400/2; // Freqence in ms, / 2 because two alternate colors

	QWidget::show();

	if ( ! Settings::blinkedSearch() )
		m_blinkTimer.start(freq);
}

void SearchBar::hide()
{
	QWidget::hide();

	if (m_blinkTimer.isActive()) {
		m_blinkTimer.stop();
		m_blinkedTimes = 0;
		m_lineEdit->setPaletteBackgroundColor(KGlobalSettings::baseColor());
	}
}

void SearchBar::blinkBar()
{
	const int nbTimes = 3*2; // Nb of blinkings, * 2 because two alternate colors

	if (m_blinkedTimes % 2 != 0)
		m_lineEdit->setPaletteBackgroundColor(KGlobalSettings::baseColor());
	else {
		QColor altColor(KGlobalSettings::alternateBackgroundColor());
		if (altColor == KGlobalSettings::baseColor())
			altColor = Qt::yellow;
		if (altColor == KGlobalSettings::baseColor()) // baseColor() == Qt::yellow
			altColor = Qt::cyan;
		m_lineEdit->setPaletteBackgroundColor(altColor);
	}

	m_blinkedTimes++;
	if (m_blinkedTimes >= nbTimes) {
		m_blinkTimer.stop();
		Settings::setBlinkedSearch(true);
	}
}

#include "search.moc"
