/* unit-namespace.c
 *
 * vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
 ****************************************************************
 * Copyright (C) 2004, Canonical Limited
 *               Author: Robert Collins
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/vu/safe-printfmt.h"
#include "hackerlab/bugs/panic.h"
#include "hackerlab/char/str.h"
#include "libarch/namespace.h"



/* typedefs */



/* local methods */
static void 
check_namespace_parse (t_uchar const *input, enum arch_parse_package_name_type type, t_uchar const *output)
{
  t_uchar * result = arch_parse_package_name (type, NULL, input);
  invariant_str_cmp (result, output);
  lim_free (0, result);
}



int
main (int argc, char * argv[])
{
  check_namespace_parse ("archive@example.com/category--branch--1.0--base-0", arch_ret_fqversion, "archive@example.com/category--branch--1.0");
  return 0;
}

