//  appconf.cc for bbmail - an tool to display new mail in X11.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// (See the included file COPYING / GPL-2.0)
//

#include "appconf.hh"

AppConf::AppConf()
{
}

AppConf::~AppConf()
{
	delete [] appname;
	delete [] appclass;
}

void AppConf::LoadAppClass(char *value)
{
	int len;
	if (value!=NULL) {
    len =strlen(value);
  	appclass = new char[len + 1];
	  memset(appclass, 0, len + 1);
  	strncpy(appclass, value, len);
  } else {
    appclass=NULL;
  }
}

void AppConf::LoadAppName(char *value)
{
	int len;
	if (value!=NULL) {
	  len =strlen(value);
  	appname = new char[len + 1];
	  memset(appname, 0, len + 1);
  	strncpy(appname, value, len);
  } else {
    appname=NULL;
  }
}
