/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef JSENVIRONMENT_H_
#define JSENVIRONMENT_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "NonCopyable.h"
#include "Observer.h"
#include <stddef.h>
#include <memory>
#include <string>

class URI;
class BString;

/*
This class is not thread-safe but is reenterable.
That means you can't call executeScript() from different threads,
but you can recursively call it from Listener methods.
*/
class JsEnvironment
{
	DECLARE_NON_COPYABLE(JsEnvironment)
public:
	class Listener;
	class ListenerSuspender;
	class PageOpenListener;
	
	JsEnvironment(URI const& page_url);
	
	~JsEnvironment();
	
	bool executeScript(
		BString const& script,
		char const* filename, char const* js_version=0);
	
	bool executeScriptAsFunction(
		BString const& script,
		char const* filename, int lineno);
	
	void setListener(Listener& listener);
	
	void removeListener();
	
	void setListenerSuspender(ListenerSuspender& suspender);
	
	void removeListenerSuspender();
	
	void setPageOpenListener(PageOpenListener& listener);
	
	void removePageOpenListener();
private:
	class Context;
	class JsException;
	struct VersionPair;
	struct VersionComparator;
	
	std::auto_ptr<Context> m_ptrContext;
};


class JsEnvironment::Listener : public ObserverBase
{
public:
	virtual ~Listener() {}
	
	virtual void processJsOutput(char const* data, bool newline) = 0;
	
	virtual void processOnLoadAssignment() = 0;
	
	virtual void processInnerHtmlAssignment(char const* data) = 0;
};


class JsEnvironment::ListenerSuspender : public ObserverBase
{
};


class JsEnvironment::PageOpenListener : public ObserverBase
{
public:
	virtual ~PageOpenListener() {}
	
	virtual void processPageOpening(char const* url, char const* target) = 0;
};

#endif
