/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef PROXYDESCRIPTOR_H_
#define PROXYDESCRIPTOR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "SymbolicInetAddr.h"
#include <string>

class ProxyDescriptor
{
public:
	enum ProxyType { INVALID, HTTP, SOCKS4, SOCKS4A, SOCKS5 };
	
	ProxyDescriptor();
	
	ProxyDescriptor(ProxyDescriptor const& other);
	
	~ProxyDescriptor();
	
	ProxyDescriptor& operator=(ProxyDescriptor const& other);
	
	void swap(ProxyDescriptor& other);
	
	void setInvalid(std::string const& config_problem);
	
	std::string const& getProblem() const { return m_configProblem; }
	
	ProxyType getType() const { return m_type; }
	
	void setType(ProxyType type) { m_type = type; }
	
	SymbolicInetAddr const& getAddr() const { return m_addr; }
	
	void setAddr(SymbolicInetAddr const& addr) { m_addr = addr; }
	
	std::string const& getUserName() const { return m_username; }
	
	void setUserName(std::string const& username) { m_username = username; }
	
	std::string const& getPassword() const { return m_password; }
	
	void setPassword(std::string const& password) { m_password = password; }
private:
	ProxyType m_type;
	std::string m_configProblem;
	SymbolicInetAddr m_addr;
	std::string m_username;
	std::string m_password;
};

inline void swap(ProxyDescriptor& o1, ProxyDescriptor& o2)
{
	o1.swap(o2);
}

#endif
