/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2005  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef DEBUGMESSAGE_H_
#define DEBUGMESSAGE_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "AbstractDebugAgent.h"
#include "IntrusivePtr.h"
#include <sigc++/sigc++.h>
#include <gtkmm/eventbox.h>
#include <gtkmm/drawingarea.h>
#include <gdkmm/gc.h>
#include <glibmm/refptr.h>
#include <string>
#include <memory>

class DebugConnection;
class ClientRequestDescriptor;

class DebugMessage : public Gtk::EventBox
{
public:
	typedef AbstractDebugAgent::HttpMessageType Type;
	
	DebugMessage(DebugConnection* conn, int top, std::string const& headers,
		Type type, IntrusivePtr<ClientRequestDescriptor> const& client_request);
	
	virtual ~DebugMessage();
	
	DebugConnection* getConnection() { return m_pConnection; } 
public:
	// positions are relative to the DebugConnection, not DebugLayout
	int getTop() const { return m_top; }
	
	int getHeight() const { return m_height; }
	
	int getBottom() const { return m_top + m_height; }
	
	bool isOpen() const { return m_state == ST_OPEN; }
	
	void select();
	
	void unselect();
	
	bool isSelected() const { return m_isSelected; }
	
	void growBy(int increment);
	
	void finish(bool error);
	
	void ensureClosed();
	
	DebugMessage* getPrev() const { return m_pPrev; }
	
	DebugMessage* getNext() const { return m_pNext; }
	
	void setPrev(DebugMessage* prev) { m_pPrev = prev; }
	
	void setNext(DebugMessage* next) { m_pNext = next; }
	
	static Gdk::Color getColorFor(Type type);
private:
	class ContentWindow;
	enum State { ST_OPEN, ST_FINISHED, ST_ERROR };
	typedef sigc::slot<ContentWindow*> ContentWindowAccessor;
	
	void setupGraphicContexts();
	
	bool onButtonPress(GdkEventButton* event);
	
	bool onExpose(GdkEventExpose* event);
	
	void drawMainArea();
	
	void drawSelectionBorder();
	
	void showContentWindow();
	
	DebugConnection* m_pConnection;
	int m_top;
	int m_height;
	State m_state;
	bool m_isSelected;
	Type m_type;
	std::string m_headers;
	Gtk::DrawingArea m_drawingArea;
	Glib::RefPtr<Gdk::GC> m_ptrMainGC;
	Glib::RefPtr<Gdk::GC> m_ptrSelectionGC;
	IntrusivePtr<ClientRequestDescriptor> m_ptrClientRequest;
	ContentWindowAccessor m_contentWindowAccessor;
	DebugMessage* m_pPrev;
	DebugMessage* m_pNext;
};

#endif
