#!/bin/bash

GCC_VERSION="4.1.1"
GCC_CORE_URL="ftp://ftp.gnu.org/gnu/gcc/gcc-$GCC_VERSION/gcc-core-$GCC_VERSION.tar.bz2"
GCC_GPP_URL="ftp://ftp.gnu.org/gnu/gcc/gcc-$GCC_VERSION/gcc-g++-$GCC_VERSION.tar.bz2"

GTK_HEADERS_URL="http://ftp.sunsite.dk/projects/autopackage/tools/gtk-headers.tar.bz2"

LIBSIGC_VERSION="2.0.17"
LIBSIGC_URL="ftp://ftp.gnome.org/pub/gnome/sources/libsigc++/2.0/libsigc++-$LIBSIGC_VERSION.tar.bz2"

GLIBMM_VERSION="2.4.8"
GLIBMM_URL="ftp://ftp.gnome.org/pub/gnome/sources/glibmm/2.4/glibmm-$GLIBMM_VERSION.tar.bz2"

GTKMM_VERSION="2.4.11"
GTKMM_URL="ftp://ftp.gnome.org/pub/gnome/sources/gtkmm/2.4/gtkmm-$GTKMM_VERSION.tar.bz2"

ACE_VERSION="5.5.1"
ACE_URL="http://deuce.doc.wustl.edu/old_distribution/ACE-$ACE_VERSION.tar.bz2"

#unpack 'filename'
function unpack
{
  fname="$1"
  case "$fname" in
    *.gz)
      flag="-z"
      ;;
    *.bz2)
      flag="-j"
      ;;
    *)
      echo "Don't know how to unpack $fname"
      return 1
      ;;
  esac
  echo "Unpacking $fname"
  tar "$flag" -xf "$fname"
}

# fetch_and_unpack 'URL'
function fetch_and_unpack
{
  url="$1"
  fname=`basename $url`
  if [ -f "$fname" ]; then
    unpack "$fname"
  else
    echo "Fetching $url"
    if wget -c "$url"; then
      unpack "$fname"
    else
      rm -f "$fname"
      return 1
    fi
  fi
}

# remove_subdirs 'file' 'subdir1|subdir2|...'
function remove_subdirs
{
  file="$1"
  pattern="$2"
  script='
/^[ \t]*SUBDIRS[ \t]*=/ {
  :next
  s/\<('$pattern')\>//g
  /\\$/ {
    n
    b next
  }
}
'
  sed -re "$script" "$file" > "$file.temp"
  mv -fT "$file.temp" "$file"
}


(
mkdir -p build || exit 1
cd build || exit 1

rm -rf "gcc-$GCC_VERSION" || exit 1
fetch_and_unpack "$GCC_CORE_URL" || exit 1
fetch_and_unpack "$GCC_GPP_URL" || exit 1

rm -rf "gtk-headers" || exit 1
fetch_and_unpack "$GTK_HEADERS_URL" || exit 1

rm -rf "libsigc++-$LIBSIGC_VERSION" || exit 1
fetch_and_unpack "$LIBSIGC_URL" || exit 1

rm -rf "glibmm-$GLIBMM_VERSION" || exit 1
fetch_and_unpack "$GLIBMM_URL" || exit 1

rm -rf "gtkmm-$GTKMM_VERSION" || exit 1
fetch_and_unpack "$GTKMM_URL" || exit 1

rm -rf "ACE_wrappers" || exit 1
fetch_and_unpack "$ACE_URL" || exit 1

rm -rf ./install-prefix || exit 1
mkdir ./install-prefix || exit 1
PREFIX=`readlink -f ./install-prefix`
COMMON_CFLAGS="-Wall -mcpu=i586 -mtune=i686 -Os -fvisibility=hidden -ffunction-sections -fdata-sections"

export CC=apgcc
export CXX=apg++

(
cd "gcc-$GCC_VERSION" || exit 1
cd libstdc++-v3 || exit 1
echo "Patching libstdc++"

SET_GLIBC_2_2="sed -e 's/__GLIBC_MINOR__/2/g' '{}' > '{}.temp' && mv -f '{}.temp' '{}'"
SET_GLIBC_2_3="sed -e 's/__GLIBC_MINOR__/3/g' '{}' > '{}.temp' && mv -f '{}.temp' '{}'"

# This file is buggy. Most of those functions are available in glibc 2.2
find "config/locale/gnu/c++locale_internal.h" -exec \
sh -c "$SET_GLIBC_2_3" \; || exit 1

find . -type f \( -name "*.cc" -o -name "*.h" \) -exec \
sh -c "$SET_GLIBC_2_2" \; || exit 1

./configure --prefix="$PREFIX" --with-target-subdir="."  \
--enable-static --disable-shared --enable-clocale=gnu --disable-nls  \
--enable-cxx-flags="$COMMON_CFLAGS" || exit 1

make install || exit 1
cd ../.. || exit 1
rm -rf "gcc-$GCC_VERSION"
) || exit 1

(
cd "gtk-headers" || exit 1
make install PREFIX="$PREFIX" || exit 1
cd .. || exit 1
rm -rf "gtk-headers"
) || exit 1

export PKG_CONFIG_PATH="$PREFIX/lib/pkgconfig:$PKG_CONFIG_PATH";
export APBUILD_INCLUDE="$PREFIX/gtk-headers/2.4:$PREFIX/include:$PREFIX/include/c++"
export LIBS="-lstdc++"

(
cd "libsigc++-$LIBSIGC_VERSION" || exit 1
echo "Patching libsigc++"
remove_subdirs "Makefile.in" "docs|tests|examples" || exit 1
./configure --prefix="$PREFIX" --enable-static --disable-shared  \
CXXFLAGS="$COMMON_CFLAGS" || exit 1
make all install || exit 1
cd .. || exit 1
rm -rf "libsigc++-$LIBSIGC_VERSION"
) || exit 1

(
cd "glibmm-$GLIBMM_VERSION" || exit 1
echo "Patching glibmm"
remove_subdirs "Makefile.in" "docs|tests|examples" || exit 1
./configure --prefix="$PREFIX" --enable-static --disable-shared  \
CXXFLAGS="$COMMON_CFLAGS" || exit 1
make all install || exit 1
cd .. || exit 1
rm -rf "glibmm-$GLIBMM_VERSION"
) || exit 1

(
cd "gtkmm-$GTKMM_VERSION" || exit 1
echo "Patching gtkmm"
remove_subdirs "Makefile.in" "docs|tests" || exit 1
./configure --prefix="$PREFIX" --enable-static --disable-shared  \
--disable-demos --disable-examples CXXFLAGS="$COMMON_CFLAGS" || exit 1
make all install || exit 1
cd .. || exit 1
rm -rf "gtkmm-$GTKMM_VERSION"
) || exit 1

(
cd "ACE_wrappers" || exit 1
export ACE_ROOT=`pwd`
echo "Configuring ACE"

cat > include/makeinclude/platform_macros.GNU <<END
static_libs_only = 1
debug = 0
optimize = 0
ace_other = 0
ace_codecs = 0
ace_svcconf = 0
ace_uuid = 0
ace_filecache = 0
acexml = 0

CC = apgcc
CXX = apg++
CFLAGS = $COMMON_CFLAGS

include \$(ACE_ROOT)/include/makeinclude/platform_linux.GNU
END

cat > ace/config.h <<END
#define ACE_NLOGGING
#define ACE_LACKS_ACE_SVCCONF
#include "config-linux.h"
END

cd ace || exit 1
make || exit 1
mkdir -p "$PREFIX/include/ace" || exit 1
mkdir -p "$PREFIX/lib" || exit 1
cp -frp os_include "$PREFIX/include/ace/" || exit 1
cp -fp *.h *.inl *.cpp "$PREFIX/include/ace/" || exit 1
cp -fp libACE.a "$PREFIX/lib/" || exit 1
cd ../.. || exit 1
rm -rf "ACE_wrappers"
) || exit 1

)
