INCLUDE(UsePkgConfig)

# - Locate libsigc++ 2.0.x
# This module defines
#  SIGC_FOUND -- true if libsigc++ was found
#  SIGC_LIBRARY -- the library to link against
#  SIGC_INCLUDE_DIR, SIGC_CONFIG_DIR -- include directories
#  SIGC_CFLAGS -- additional compile flags, to be used like this:
#      ADD_DEFINITIONS("${SIGC_CFLAGS}")
#  SIGC_LINKFLAGS -- additional link flags, to be used like this:
#      SET_TARGET_PROPERTIES(target PROPERTIES LINK_FLAGS "${SIGC_LINKFLAGS}")
MACRO(BF_FIND_SIGC)
	PKGCONFIG(sigc++-2.0 tmp1_ tmp2_ SIGC_LINKFLAGS SIGC_CFLAGS)
	SET(SIGC_FOUND FALSE)
	IF(SIGC_LINKFLAGS)
		SET(SIGC_FOUND TRUE)
	ELSE(SIGC_LINKFLAGS)
		GET_FILENAME_COMPONENT(parent_dir_ "${PROJECT_SOURCE_DIR}/.." ABSOLUTE)
		FILE(GLOB sigc_dirs_ "${parent_dir_}/libsigc++-2.*.*[0-9]")
		FIND_PATH(
			SIGC_INCLUDE_DIR sigc++/sigc++.h
			PATHS /usr/include /usr/local/include
			"${CMAKE_INSTALL_PREFIX}/include" ${sigc_dirs_}
			PATH_SUFFIXES sigc++-2.0
			DOC "Path to sigc++/sigc++.h"
		)
		FIND_PATH(
			SIGC_CONFIG_DIR sigc++config.h
			PATHS /usr/lib /usr/local/lib
			"${CMAKE_INSTALL_PREFIX}/lib" ${sigc_dirs_}
			PATH_SUFFIXES  sigc++-2.0/include
			DOC "Path to sigc++config.h"
		)
		FIND_LIBRARY(
			SIGC_LIBRARY NAMES sigc-2.0 sigc
			PATHS /usr/lib /usr/local/lib
			"${CMAKE_INSTALL_PREFIX}/lib" ${sigc_dirs_}
			PATH_SUFFIXES sigc++
			DOC "Path to sigc++ library file"
		)
		IF(SIGC_INCLUDE_DIR AND SIGC_CONFIG_DIR AND SIGC_LIBRARY)
			SET(SIGC_FOUND TRUE)
		ENDIF(SIGC_INCLUDE_DIR AND SIGC_CONFIG_DIR AND SIGC_LIBRARY)
	ENDIF(SIGC_LINKFLAGS)
ENDMACRO(BF_FIND_SIGC)
