/*
    BFilter - a smart ad-filtering web proxy
    Copyright (C) 2002-2006  Joseph Artsimovich <joseph_a@mail.ru>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "pch.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "EncOps.h"
#include <glibmm/convert.h>
#include <vector>
#include <stddef.h>

namespace
{

std::string anythingToASCII(std::string const& input)
{
	if (input.empty()) {
		return input;
	}
	
	std::vector<char> buf(input.c_str(), input.c_str() + input.size());
	char* p = &buf[0];
	char* end = p + buf.size();
	for (; p != end; ++p) {
		if ((unsigned char)*p > 127) {
			*p = '?';
		}
	}
	return std::string(&buf[0], buf.size());
}

} // anonymous namespace

namespace GtkGUI
{

namespace EncOps
{

Glib::ustring localeToUtf8(std::string const& text)
{
	try {
		return Glib::locale_to_utf8(text);
	} catch (Glib::ConvertError const&) {
		return anythingToASCII(text);
	}
}

std::string localeFromUtf8(Glib::ustring const& text)
{
	try {
		return Glib::locale_from_utf8(text);
	} catch (Glib::ConvertError const&) {
		std::string charset;
		Glib::get_charset(charset);
		try {
			return Glib::convert_with_fallback(text, charset, "utf8", "?");
		} catch (Glib::ConvertError const&) {
			return anythingToASCII(text.raw());
		}
	}
}

Glib::ustring filenameToUtf8(std::string const& fname)
{
	// glib 2.6 has g_filename_display_name() that does what we want,
	// but we don't want to depend on glib 2.6.
	try {
		return Glib::filename_to_utf8(fname);
	} catch (Glib::ConvertError& e) {
		return anythingToASCII(fname);
	}
}

} // namespace EncOps

} // namespace GtkGUI
