/*
Copyright 2010, 2012, 2014 Jose Robson Mariano Alves

This file is part of bgfinancas.

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*/

package Movimentacoes;

import Biblioteca.Botoes;
import Biblioteca.Calendario;
import Biblioteca.Datas;
import Biblioteca.Janela;
import Biblioteca.Janelinha;
import Biblioteca.Visual;
import Principal.TelaPrincipal;
import java.sql.SQLException;
import javax.swing.table.DefaultTableModel;

public final class ReceitasPesquisar extends Janela {

    private final String Acao;
    private final Receitas Receitas;
    private final TelaPrincipal Principal;

    public ReceitasPesquisar(TelaPrincipal principal, Receitas receitas, String acao) {
        initComponents();
        Visual.Janela(this.getJanela());
        BarraDeFerramentas.add(Botoes.Sair(this));
        Receitas = receitas;
        Acao = acao;
        Principal = principal;
        PreencherCategorias();
        resultado_pesquisa.setFont(FonteFinancas);
        resultado_pesquisa.getTableHeader().setFont(FonteFinancas);
    }

    public void PreencherCategorias()
    {
        try
        {
            categoria.addItem(Lingua.getMensagem("todas"));
            Banco.executeQuery("SELECT nome FROM receitas_categorias ORDER BY nome ASC");
            while(Banco.getResultSet().next())
            {
                categoria.addItem(Banco.getResultSet().getString("nome"));
            }
        }catch(SQLException e)
        {
            categoria.addItem(Lingua.getMensagem("nenhum_item_encontrado"));
        }
    }

    public void Filtrar()
    {
        String Categoria = (String)categoria.getSelectedItem();
        if(Categoria.equals(Lingua.getMensagem("todas"))){ Categoria=""; }
        if(data_inicial.getSelectedItem()==null || data_final.getSelectedItem()==null)
        {
            Banco.executeQuery("SELECT receitas.*, TO_CHAR(receitas.data,'DD/MM/YYYY') AS data_exibir, receitas_itens.nome AS item_nome, receitas_categorias.nome AS categoria_nome FROM receitas, receitas_itens, receitas_categorias WHERE receitas_itens.nome LIKE '%"+item.getText()+"%' AND receitas.id_item=receitas_itens.id_item AND receitas_categorias.nome LIKE '%"+Categoria+"%' AND receitas_itens.id_categoria=receitas_categorias.id_categoria ORDER BY receitas.data DESC, receitas.hora DESC");
        }else{
            Banco.executeQuery("SELECT receitas.*, TO_CHAR(receitas.data,'DD/MM/YYYY') AS data_exibir, receitas_itens.nome AS item_nome, receitas_categorias.nome AS categoria_nome FROM receitas, receitas_itens, receitas_categorias WHERE receitas_itens.nome LIKE '%"+item.getText()+"%' AND receitas.data>='"+Datas.ConverterData(data_inicial.getSelectedItem().toString())+"' AND receitas.data<='"+Datas.ConverterData(data_final.getSelectedItem().toString())+"' AND receitas_categorias.nome LIKE '%"+Categoria+"%' AND receitas.id_item=receitas_itens.id_item AND receitas_itens.id_categoria=receitas_categorias.id_categoria ORDER BY receitas.data DESC, receitas.hora DESC");
        }

        try
        {
            DefaultTableModel modelo = (DefaultTableModel)resultado_pesquisa.getModel();
            modelo.setNumRows(0);
            while(Banco.getResultSet().next())
            {
                modelo.addRow(new Object[]{Banco.getResultSet().getString("id_receita"),Banco.getResultSet().getString("item_nome"),Banco.getResultSet().getString("categoria_nome"),Lingua.getMensagem("moeda")+" "+Banco.getResultSet().getString("valor"),Banco.getResultSet().getString("data_exibir")+" "+Banco.getResultSet().getString("hora")});
            }
        }catch(SQLException e)
        {
            Janelinha.Aviso(Lingua.getMensagem("atencao"),Lingua.getMensagem("excecao")+" "+e.getMessage());
        }
    }
    
    @Override
    public void Botoes(String acao)
    {
        if(acao.equals(Lingua.getMensagem("sair"))){
            ReceitasPesquisar.this.dispose();
        }
    }
    

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        BarraDeFerramentas = new javax.swing.JToolBar();
        pesquisar_venda = new javax.swing.JPanel();
        scroll_pesquisa = new javax.swing.JScrollPane();
        resultado_pesquisa = new javax.swing.JTable();
        CLIENTE_NOME = new javax.swing.JLabel();
        item = new javax.swing.JTextField();
        ESTADO = new javax.swing.JLabel();
        BFiltrar = new javax.swing.JButton();
        categoria = new javax.swing.JComboBox();
        ESTADO1 = new javax.swing.JLabel();
        ESTADO2 = new javax.swing.JLabel();
        data_inicial = new Calendario(false);
        data_final = new Calendario(false);

        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jScrollPane1.setViewportView(jTable1);

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle(Lingua.getMensagem("pesquisar"));
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));

        BarraDeFerramentas.setFloatable(false);
        BarraDeFerramentas.setRollover(true);

        pesquisar_venda.setBorder(javax.swing.BorderFactory.createTitledBorder(null, Lingua.getMensagem("receita"), javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, FonteFinancas, new java.awt.Color(0, 102, 204)));
        pesquisar_venda.setForeground(new java.awt.Color(51, 94, 168));
        pesquisar_venda.setLayout(null);

        resultado_pesquisa.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "ID", "", "", "", ""
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false, false, false, false, false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        resultado_pesquisa.getTableHeader().setReorderingAllowed(false);
        resultado_pesquisa.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                resultado_pesquisaMouseClicked(evt);
            }
        });
        scroll_pesquisa.setViewportView(resultado_pesquisa);
        if (resultado_pesquisa.getColumnModel().getColumnCount() > 0) {
            resultado_pesquisa.getColumnModel().getColumn(0).setMaxWidth(40);
            resultado_pesquisa.getColumnModel().getColumn(1).setHeaderValue(Lingua.getMensagem("nome"));
            resultado_pesquisa.getColumnModel().getColumn(2).setHeaderValue(Lingua.getMensagem("categoria"));
            resultado_pesquisa.getColumnModel().getColumn(3).setHeaderValue(Lingua.getMensagem("valor"));
            resultado_pesquisa.getColumnModel().getColumn(4).setHeaderValue(Lingua.getMensagem("data"));
        }

        pesquisar_venda.add(scroll_pesquisa);
        scroll_pesquisa.setBounds(18, 93, 576, 310);

        CLIENTE_NOME.setFont(FonteFinancas);
        CLIENTE_NOME.setForeground(new java.awt.Color(51, 94, 168));
        CLIENTE_NOME.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        CLIENTE_NOME.setText(Lingua.getMensagem("item")+":");
        pesquisar_venda.add(CLIENTE_NOME);
        CLIENTE_NOME.setBounds(18, 32, 70, 20);

        item.setFont(FonteFinancas);
        item.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                itemActionPerformed(evt);
            }
        });
        pesquisar_venda.add(item);
        item.setBounds(100, 30, 230, 20);

        ESTADO.setFont(FonteFinancas);
        ESTADO.setForeground(new java.awt.Color(51, 94, 168));
        ESTADO.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        ESTADO.setText(Lingua.getMensagem("de")+":");
        pesquisar_venda.add(ESTADO);
        ESTADO.setBounds(330, 30, 50, 20);

        BFiltrar.setBackground(new java.awt.Color(226, 224, 255));
        BFiltrar.setFont(FonteFinancas);
        BFiltrar.setText(Lingua.getMensagem("pesquisar"));
        BFiltrar.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        BFiltrar.setFocusPainted(false);
        BFiltrar.setRequestFocusEnabled(false);
        BFiltrar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                BFiltrarActionPerformed(evt);
            }
        });
        pesquisar_venda.add(BFiltrar);
        BFiltrar.setBounds(520, 33, 70, 50);

        categoria.setFont(FonteFinancas);
        categoria.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                categoriaActionPerformed(evt);
            }
        });
        pesquisar_venda.add(categoria);
        categoria.setBounds(100, 60, 230, 20);

        ESTADO1.setFont(FonteFinancas);
        ESTADO1.setForeground(new java.awt.Color(51, 94, 168));
        ESTADO1.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        ESTADO1.setText(Lingua.getMensagem("categoria")+":");
        pesquisar_venda.add(ESTADO1);
        ESTADO1.setBounds(20, 60, 70, 20);

        ESTADO2.setFont(FonteFinancas);
        ESTADO2.setForeground(new java.awt.Color(51, 94, 168));
        ESTADO2.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        ESTADO2.setText(Lingua.getMensagem("ate")+":");
        pesquisar_venda.add(ESTADO2);
        ESTADO2.setBounds(330, 60, 50, 20);

        data_inicial.setFont(FonteFinancas);
        pesquisar_venda.add(data_inicial);
        data_inicial.setBounds(390, 30, 120, 20);

        data_final.setFont(FonteFinancas);
        pesquisar_venda.add(data_final);
        data_final.setBounds(390, 60, 120, 20);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(BarraDeFerramentas, javax.swing.GroupLayout.DEFAULT_SIZE, 632, Short.MAX_VALUE)
            .addGroup(layout.createSequentialGroup()
                .addGap(10, 10, 10)
                .addComponent(pesquisar_venda, javax.swing.GroupLayout.DEFAULT_SIZE, 604, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(BarraDeFerramentas, javax.swing.GroupLayout.PREFERRED_SIZE, 41, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(pesquisar_venda, javax.swing.GroupLayout.DEFAULT_SIZE, 418, Short.MAX_VALUE)
                .addContainerGap())
        );

        setSize(new java.awt.Dimension(640, 514));
        setLocationRelativeTo(null);
    }// </editor-fold>//GEN-END:initComponents

private void itemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_itemActionPerformed
    Filtrar();
}//GEN-LAST:event_itemActionPerformed

private void BFiltrarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_BFiltrarActionPerformed
    Filtrar();
}//GEN-LAST:event_BFiltrarActionPerformed

private void resultado_pesquisaMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_resultado_pesquisaMouseClicked
    String codSelecionado0;
    String codSelecionado1;
    String codSelecionado3;
    codSelecionado0 = (String)resultado_pesquisa.getValueAt(resultado_pesquisa.getSelectedRow(), 0);
    codSelecionado1 = (String)resultado_pesquisa.getValueAt(resultado_pesquisa.getSelectedRow(), 1);
    codSelecionado3 = (String)resultado_pesquisa.getValueAt(resultado_pesquisa.getSelectedRow(), 3);
    if(Janelinha.Pergunta(codSelecionado1, Lingua.getMensagem("tem_certeza"))){
        Receitas.PreencherFormulario(Acao, codSelecionado0);
        ReceitasPesquisar.this.dispose();
    }
}//GEN-LAST:event_resultado_pesquisaMouseClicked

private void categoriaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_categoriaActionPerformed
    Filtrar();
}//GEN-LAST:event_categoriaActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton BFiltrar;
    private javax.swing.JToolBar BarraDeFerramentas;
    private javax.swing.JLabel CLIENTE_NOME;
    private javax.swing.JLabel ESTADO;
    private javax.swing.JLabel ESTADO1;
    private javax.swing.JLabel ESTADO2;
    private javax.swing.JComboBox categoria;
    private javax.swing.JComboBox data_final;
    private javax.swing.JComboBox data_inicial;
    private javax.swing.JTextField item;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    private javax.swing.JPanel pesquisar_venda;
    private javax.swing.JTable resultado_pesquisa;
    private javax.swing.JScrollPane scroll_pesquisa;
    // End of variables declaration//GEN-END:variables

}
