/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __KOZO_DB_PRIVATE_H__
#define __KOZO_DB_PRIVATE_H__

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <errno.h>

#include "kozo-db.h"
#include <tdb.h>

#include "kozo-pack.h"

void kozo_db_init             (void);
void kozo_db_shutdown         (void);

void kozo_db_reader_lock      (KozoDB          *db);
void kozo_db_reader_unlock    (KozoDB          *db);

void kozo_db_writer_lock      (KozoDB          *db);
void kozo_db_writer_unlock    (KozoDB          *db);

void kozo_db_associate_lock   (KozoDB          *db);
void kozo_db_associate_unlock (KozoDB          *db);

TDB_CONTEXT  *kozo_db_get_db  (KozoDB          *db);

void kozo_db_set_g_error      (GError         **error,
                               int              err);

void kozo_db_harvest_entry    (const TDB_DATA   key,
                               const TDB_DATA   data,
                               KozoPackContext *c,
                               GSList          *field_ids);

#endif /* __KOZO_DB_PRIVATE_H__ */
