/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */
/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __KOZO_UTIL_H__
#define __KOZO_UTIL_H__

#include <fcntl.h>
#include <obstack.h>

#include "kozo-entry.h"

#define obstack_chunk_alloc g_malloc
#define obstack_chunk_free g_free

typedef struct {
        KozoEntry **array;

        guint len;
        guint max;

        struct obstack obstack;
} KozoEntryArray;

void            kozo_entry_array_init    (KozoEntryArray *array,
                                          guint           begin_size);
void            kozo_entry_array_resize  (KozoEntryArray *array,
                                          guint           new_size);
void            kozo_entry_array_destroy (KozoEntryArray *array);

KozoEntryArray *kozo_entry_array_new     (guint           begin_size);
void            kozo_entry_array_free    (KozoEntryArray *array);

void            kozo_entry_array_append  (KozoEntryArray *array,
                                          guint8         *data,
                                          guint32         length);

void kozo_util_init     (void);
void kozo_util_shutdown (void);

void kozo_init (void);
void kozo_shutdown (void);

#endif /* __KOZO_UTIL_H__ */
